/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.het.solver;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.het.solver.HetSolution;
import com.duckblade.osrs.toa.features.het.solver.HetSolutionResult;
import com.duckblade.osrs.toa.features.het.solver.HetSolver;
import com.duckblade.osrs.toa.features.het.solver.HetTileState;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class HetSolverOverlay
extends Overlay
implements PluginLifecycleComponent {
    private final OverlayManager overlayManager;
    private final Client client;
    private final HetSolver hetSolver;

    @Inject
    public HetSolverOverlay(OverlayManager overlayManager, Client client, HetSolver hetSolver) {
        this.overlayManager = overlayManager;
        this.client = client;
        this.hetSolver = hetSolver;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.hetSolverEnable() && raidState.getCurrentRoom() == RaidRoom.HET;
    }

    @Override
    public void startUp() {
        this.overlayManager.add(this);
    }

    @Override
    public void shutDown() {
        this.overlayManager.removeIf(o -> o instanceof HetSolverOverlay);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        HetSolution sol = this.hetSolver.getSolution();
        if (sol == null) {
            return null;
        }
        HetSolutionResult res = sol.getScore(this.hetSolver.getRoomStates());
        for (HetTileState incorrectState : res.getIncorrectStates()) {
            int sceneY;
            int sceneX;
            Polygon tile;
            if (incorrectState.getState() == 0) {
                Shape hull;
                GameObject highlightObj = this.hetSolver.getRoomObjects()[incorrectState.getX()][incorrectState.getY()];
                if (highlightObj == null || (hull = highlightObj.getConvexHull()) == null) continue;
                OverlayUtil.renderPolygon(g2, hull, Color.red);
                continue;
            }
            if (incorrectState.getState() != 1 || (tile = Perspective.getCanvasTilePoly(this.client, LocalPoint.fromScene(sceneX = incorrectState.getX() + this.hetSolver.getPuzzleBase().getX(), sceneY = incorrectState.getY() + this.hetSolver.getPuzzleBase().getY()))) == null) continue;
            OverlayUtil.renderPolygon(g2, tile, Color.red);
            Point sw = new Point(tile.xpoints[0], tile.ypoints[0]);
            Point se = new Point(tile.xpoints[1], tile.ypoints[1]);
            Point ne = new Point(tile.xpoints[2], tile.ypoints[2]);
            Point nw = new Point(tile.xpoints[3], tile.ypoints[3]);
            Polygon tri = new Polygon();
            switch (incorrectState.getOrientation()) {
                case 0: {
                    tri.addPoint(nw.x, nw.y);
                    tri.addPoint(ne.x, ne.y);
                    tri.addPoint(se.x, se.y);
                    break;
                }
                case 1: {
                    tri.addPoint(sw.x, sw.y);
                    tri.addPoint(se.x, se.y);
                    tri.addPoint(ne.x, ne.y);
                    break;
                }
                case 2: {
                    tri.addPoint(nw.x, nw.y);
                    tri.addPoint(sw.x, sw.y);
                    tri.addPoint(se.x, se.y);
                    break;
                }
                default: {
                    tri.addPoint(sw.x, sw.y);
                    tri.addPoint(nw.x, nw.y);
                    tri.addPoint(ne.x, ne.y);
                }
            }
            g2.setColor(Color.red);
            g2.fill(tri);
        }
        return null;
    }
}

