/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.EvictingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SequencePuzzleSolver
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SequencePuzzleSolver.class);
    private static final int GROUND_OBJECT_ID = 45340;
    private static final int DISPLAY_GAME_OBJECT_ID = 45341;
    private static final int STEPPED_GAME_OBJECT_ID = 45342;
    private static final int GRAPHICS_OBJECT_RESET = 302;
    private final EventBus eventBus;
    private final Client client;
    private final EvictingQueue<LocalPoint> points = EvictingQueue.create(5);
    private int completedTiles = 0;
    private boolean puzzleFinished = false;
    private int lastDisplayTick = 0;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && raidState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        this.reset();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (this.puzzleFinished) {
            return;
        }
        switch (e.getGameObject().getId()) {
            case 45341: {
                this.lastDisplayTick = this.client.getTickCount();
                if (this.lastDisplayTick == this.lastDisplayTick) {
                    this.reset();
                    this.puzzleFinished = true;
                    return;
                }
                this.points.add(e.getTile().getLocalLocation());
                this.completedTiles = 0;
                break;
            }
            case 45342: {
                ++this.completedTiles;
            }
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated e) {
        if (e.getGraphicsObject().getId() == 302) {
            LocalPoint gLoc = e.getGraphicsObject().getLocation();
            Tile gTile = this.client.getScene().getTiles()[this.client.getPlane()][gLoc.getSceneX()][gLoc.getSceneY()];
            if (gTile.getGroundObject() != null && gTile.getGroundObject().getId() == 45340) {
                this.reset();
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getMessage().startsWith("Your party failed to complete the challenge")) {
            this.reset();
        }
    }

    private void reset() {
        this.puzzleFinished = false;
        this.points.clear();
        this.completedTiles = 0;
        this.lastDisplayTick = 0;
    }

    @Inject
    public SequencePuzzleSolver(EventBus eventBus, Client client) {
        this.eventBus = eventBus;
        this.client = client;
    }

    public EvictingQueue<LocalPoint> getPoints() {
        return this.points;
    }

    public int getCompletedTiles() {
        return this.completedTiles;
    }
}

