/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.experiencedrop;

import com.google.inject.Provides;
import com.openosrs.client.game.NPCManager;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.experiencedrop.PrayerType;
import net.runelite.client.plugins.experiencedrop.XpDropConfig;
import net.runelite.client.plugins.experiencedrop.XpDropOverlay;
import net.runelite.client.plugins.experiencedrop.XpPrayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;

@PluginDescriptor(name="XP Drop", description="Enable customization of the way XP drops are displayed", tags={"experience", "levels", "tick", "prayer", "xpdrop"})
public class XpDropPlugin
extends Plugin {
    private static final double HITPOINT_RATIO = 1.33;
    private static final double DMM_MULTIPLIER_RATIO = 10.0;
    @Inject
    private Client client;
    @Inject
    private XpDropConfig config;
    @Inject
    private NPCManager npcManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private XpDropOverlay overlay;
    private int tickCounter = 0;
    private int previousExpGained;
    private boolean hasDropped = false;
    private boolean correctPrayer;
    private Skill lastSkill = null;
    private final Map<Skill, Integer> previousSkillExpTable = new EnumMap<Skill, Integer>(Skill.class);
    private int damage = 0;
    private int tickShow = 0;
    private Actor lastOpponent;

    @Provides
    XpDropConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(XpDropConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.overlay);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() == 996) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            int widgetId = intStack[intStackSize - 4];
            this.processXpDrop(widgetId);
        }
    }

    private void processXpDrop(int widgetId) {
        Widget xpdrop = this.client.getWidget(widgetId);
        Widget[] children = xpdrop.getChildren();
        Widget text = children[0];
        PrayerType prayer = this.getActivePrayerType();
        if (prayer == null) {
            this.hideSkillIcons(xpdrop);
            this.resetTextColor(text);
            return;
        }
        IntStream spriteIDs = Arrays.stream(children).skip(1L).filter(Objects::nonNull).mapToInt(Widget::getSpriteId);
        int color = 0;
        switch (prayer) {
            case MELEE: {
                if (!this.correctPrayer && !spriteIDs.anyMatch(id -> id == 197 || id == 198 || id == 199)) break;
                color = this.config.getMeleePrayerColor().getRGB();
                this.correctPrayer = true;
                break;
            }
            case RANGE: {
                if (!this.correctPrayer && !spriteIDs.anyMatch(id -> id == 200)) break;
                color = this.config.getRangePrayerColor().getRGB();
                this.correctPrayer = true;
                break;
            }
            case MAGIC: {
                if (!this.correctPrayer && !spriteIDs.anyMatch(id -> id == 202)) break;
                color = this.config.getMagePrayerColor().getRGB();
                this.correctPrayer = true;
            }
        }
        if (color != 0) {
            text.setTextColor(color);
        } else {
            this.resetTextColor(text);
        }
        this.hideSkillIcons(xpdrop);
    }

    private void resetTextColor(Widget widget) {
        Color standardColor = this.config.standardColor();
        if (standardColor != null) {
            int color = standardColor.getRGB();
            widget.setTextColor(color);
        } else {
            EnumComposition colorEnum = this.client.getEnum(1169);
            int defaultColorId = this.client.getVarbitValue(4695);
            int color = colorEnum.getIntValue(defaultColorId);
            widget.setTextColor(color);
        }
    }

    private void hideSkillIcons(Widget xpdrop) {
        if (this.config.hideSkillIcons()) {
            Object[] children = xpdrop.getChildren();
            Arrays.fill(children, 1, children.length, null);
        }
    }

    private PrayerType getActivePrayerType() {
        for (XpPrayer prayer : XpPrayer.values()) {
            if (this.client.getServerVarbitValue(prayer.getPrayer().getVarbit()) != 1) continue;
            return prayer.getType();
        }
        return null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.tickShow = 0;
        this.damage = 0;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.lastOpponent = this.client.getLocalPlayer().getInteracting();
        if (this.tickShow > 0) {
            --this.tickShow;
        }
        this.correctPrayer = false;
        int fakeTickDelay = this.config.fakeXpDropDelay();
        if (fakeTickDelay == 0 || this.lastSkill == null) {
            return;
        }
        if (this.hasDropped) {
            this.hasDropped = false;
            this.tickCounter = 0;
            return;
        }
        if (++this.tickCounter % fakeTickDelay != 0) {
            return;
        }
        this.client.runScript(2091, this.lastSkill.ordinal(), this.previousExpGained);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xp = statChanged.getXp();
        this.lastSkill = skill;
        Integer previous = this.previousSkillExpTable.put(skill, xp);
        if (previous != null) {
            this.previousExpGained = xp - previous;
            this.hasDropped = true;
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent e) {
        if (this.config.showdamagedrops() == XpDropConfig.DamageMode.NONE) {
            return;
        }
        String eventName = e.getEventName();
        if (eventName.equals("newXpDrop")) {
            this.damage = 0;
        } else if (eventName.equals("fakeXpDrop")) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            int skillId = intStack[intStackSize - 2];
            Skill skill = Skill.values()[skillId];
            if (skill.equals((Object)Skill.HITPOINTS)) {
                int exp = intStack[intStackSize - 1];
                this.calculateDamageDealt(exp);
            }
        } else if (eventName.equals("hpXpGained")) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            int exp = intStack[intStackSize - 1];
            this.calculateDamageDealt(exp);
        } else if (eventName.equals("xpDropAddDamage") && this.config.showdamagedrops() == XpDropConfig.DamageMode.IN_XP_DROP && this.damage > 0) {
            String[] stringStack = this.client.getStringStack();
            int stringStackSize = this.client.getStringStackSize();
            String builder = stringStack[stringStackSize - 1] + ColorUtil.colorTag(this.config.getDamageColor()) + " (" + this.damage + ")";
            stringStack[stringStackSize - 1] = builder;
        }
    }

    private void calculateDamageDealt(int diff) {
        Actor a;
        double damageDealt = (double)diff / 1.33;
        if (this.client.getWorldType().contains((Object)WorldType.DEADMAN)) {
            damageDealt /= 10.0;
        }
        if (!((a = this.client.getLocalPlayer().getInteracting()) instanceof NPC) && !(a instanceof Player)) {
            if (!(this.lastOpponent instanceof NPC) && !(this.lastOpponent instanceof Player)) {
                this.damage = (int)Math.rint(damageDealt);
                this.tickShow = 3;
                return;
            }
            a = this.lastOpponent;
        }
        if (a instanceof Player) {
            this.damage = (int)Math.rint(damageDealt);
            this.tickShow = 3;
            return;
        }
        NPC target = (NPC)a;
        this.damage = (int)Math.rint(damageDealt / this.npcManager.getXpModifier(target.getId()));
        this.tickShow = 3;
    }

    int getDamage() {
        return this.damage;
    }

    int getTickShow() {
        return this.tickShow;
    }

    Actor getLastOpponent() {
        return this.lastOpponent;
    }
}

