/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import net.runelite.client.ui.ColorScheme;

public class SliderUI
extends BasicSliderUI {
    private final Color rangeColor = ColorScheme.BRAND_BLUE;
    private final BasicStroke stroke = new BasicStroke(2.0f);
    private transient boolean upperDragging;

    public SliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SliderUI((JSlider)c);
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.thumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    @Override
    protected void calculateThumbLocation() {
        int upperPosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.thumbRect.x = upperPosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = upperPosition - this.thumbRect.height / 2;
        }
        this.slider.repaint();
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(16, 16);
    }

    private Shape createThumbShape(int width, int height) {
        return new Ellipse2D.Double(0.0, 0.0, width, height);
    }

    @Override
    public void paintTrack(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        Stroke old = g2d.getStroke();
        g2d.setStroke(this.stroke);
        g2d.setPaint(ColorScheme.LIGHT_GRAY_COLOR);
        Color oldColor = ColorScheme.LIGHT_GRAY_COLOR;
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            g2d.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2);
            int lowerX = this.thumbRect.width / 2;
            int upperX = this.thumbRect.x + this.thumbRect.width / 2;
            int cy = trackBounds.height / 2 - 2;
            g2d.translate(trackBounds.x, trackBounds.y + cy);
            g2d.setColor(this.rangeColor);
            g2d.drawLine(lowerX - trackBounds.x, 2, upperX - trackBounds.x, 2);
            g2d.translate(-trackBounds.x, -(trackBounds.y + cy));
            g2d.setColor(oldColor);
        }
        g2d.setStroke(old);
    }

    @Override
    public void paintThumb(Graphics g2) {
        Rectangle knobBounds = this.thumbRect;
        int w = knobBounds.width;
        int h2 = knobBounds.height;
        Graphics2D g2d = (Graphics2D)g2.create();
        Shape thumbShape = this.createThumbShape(w - 1, h2 - 1);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(knobBounds.x, knobBounds.y);
        g2d.setColor(ColorScheme.BRAND_BLUE);
        g2d.fill(thumbShape);
        g2d.setColor(ColorScheme.DARK_GRAY_COLOR);
        g2d.draw(thumbShape);
        g2d.dispose();
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(SliderUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX -= ((SliderUI)SliderUI.this).thumbRect.width / 2;
            this.moveUpperThumb();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SliderUI.this.slider.isRequestFocusEnabled()) {
                SliderUI.this.slider.requestFocus();
            }
            boolean upperPressed = false;
            if (SliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (upperPressed) {
                switch (SliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SliderUI)SliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SliderUI)SliderUI.this).thumbRect.x;
                    }
                }
                SliderUI.this.upperDragging = true;
                return;
            }
            SliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SliderUI.this.upperDragging = false;
            SliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SliderUI.this.upperDragging) {
                SliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        public void moveUpperThumb() {
            if (SliderUI.this.slider.getOrientation() == 0) {
                int halfThumbWidth = ((SliderUI)SliderUI.this).thumbRect.width / 2;
                int thumbLeft = this.currentMouseX - this.offset;
                int trackLeft = ((SliderUI)SliderUI.this).trackRect.x;
                int trackRight = ((SliderUI)SliderUI.this).trackRect.x + (((SliderUI)SliderUI.this).trackRect.width - 1);
                int hMax = SliderUI.this.xPositionForValue(SliderUI.this.slider.getMaximum() - SliderUI.this.slider.getExtent());
                if (SliderUI.this.drawInverted()) {
                    trackLeft = hMax;
                } else {
                    trackRight = hMax;
                }
                thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                SliderUI.this.setThumbLocation(thumbLeft, ((SliderUI)SliderUI.this).thumbRect.y);
                int thumbMiddle = thumbLeft + halfThumbWidth;
                SliderUI.this.slider.setValue(SliderUI.this.valueForXPosition(thumbMiddle));
            }
        }
    }
}

