/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.data.WaterType;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Overlay;
import rs117.hd.data.materials.Underlay;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.scene.model_overrides.ObjectType;
import rs117.hd.scene.model_overrides.TzHaarRecolorType;
import rs117.hd.utils.HDUtils;

@Singleton
public class ProceduralGenerator {
    private static final Logger log = LoggerFactory.getLogger(ProceduralGenerator.class);
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    private final int VERTICES_PER_FACE = 3;
    Map<Integer, Integer> vertexTerrainColor;
    Map<Integer, Material> vertexTerrainTexture;
    Map<Integer, float[]> vertexTerrainNormals;
    HashMap<Integer, Boolean> highPriorityColor;
    boolean[][][] tileIsWater;
    Map<Integer, Boolean> vertexIsWater;
    Map<Integer, Boolean> vertexIsLand;
    Map<Integer, Boolean> vertexIsOverlay;
    Map<Integer, Boolean> vertexIsUnderlay;
    boolean[][][] skipTile;
    Map<Integer, Integer> vertexUnderwaterDepth;
    int[][][] underwaterDepthLevels;
    int[] depthLevelSlope = new int[]{150, 300, 470, 610, 700, 750, 820, 920, 1080, 1300, 1350, 1380};
    boolean[][] tileOverlayTris = new boolean[][]{{true, true, true, true}, {false, true}, {false, false, true}, {false, false, true}, {false, true, true}, {false, true, true}, {false, false, true, true}, {false, false, false, true}, {false, true, true, true}, {false, false, false, true, true, true}, {true, true, true, false, false, false}, {true, true, false, false, false, false}};
    int[][] tzHaarRecolored = new int[4][3];
    final int[] gradientBaseColor = new int[]{3, 4, 26};
    final int[] gradientDarkColor = new int[]{3, 4, 10};
    final int gradientBottom = 200;
    final int gradientTop = -200;

    public void generateTerrainData(Scene scene) {
        this.vertexTerrainColor = new HashMap<Integer, Integer>();
        this.highPriorityColor = new HashMap();
        this.vertexTerrainTexture = new HashMap<Integer, Material>();
        this.vertexIsUnderlay = new HashMap<Integer, Boolean>();
        this.vertexIsOverlay = new HashMap<Integer, Boolean>();
        Tile[][][] tiles = scene.getTiles();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    if (tiles[z][x][y] == null) continue;
                    this.generateDataForTile(tiles[z][x][y]);
                    if (tiles[z][x][y].getBridge() == null) continue;
                    this.generateDataForTile(tiles[z][x][y].getBridge());
                }
            }
        }
    }

    void generateDataForTile(Tile tile) {
        int faceCount;
        if (tile.getSceneTilePaint() != null) {
            faceCount = 2;
        } else if (tile.getSceneTileModel() != null) {
            faceCount = tile.getSceneTileModel().getFaceX().length;
        } else {
            return;
        }
        int[] vertexHashes = new int[faceCount * 3];
        int[] vertexColors = new int[faceCount * 3];
        int[] vertexOverlays = new int[faceCount * 3];
        int[] vertexUnderlays = new int[faceCount * 3];
        boolean[] vertexDefaultColor = new boolean[faceCount * 3];
        int z = tile.getRenderLevel();
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int worldX = tile.getWorldLocation().getX();
        int worldY = tile.getWorldLocation().getY();
        if (tile.getSceneTilePaint() != null) {
            if (this.tileWaterType(tile, tile.getSceneTilePaint()) != WaterType.NONE) {
                return;
            }
            int swColor = tile.getSceneTilePaint().getSwColor();
            int seColor = tile.getSceneTilePaint().getSeColor();
            int nwColor = tile.getSceneTilePaint().getNwColor();
            int neColor = tile.getSceneTilePaint().getNeColor();
            vertexHashes = this.tileVertexKeys(tile);
            if (x >= 102 && y >= 102) {
                neColor = swColor;
                nwColor = swColor;
                seColor = swColor;
            } else if (y >= 102) {
                nwColor = swColor;
                neColor = seColor;
            } else if (x >= 102) {
                neColor = nwColor;
                seColor = swColor;
            }
            vertexColors[0] = swColor;
            vertexColors[1] = seColor;
            vertexColors[2] = nwColor;
            vertexColors[3] = neColor;
            vertexOverlays[2] = vertexOverlays[3] = this.client.getScene().getOverlayIds()[z][x][y];
            vertexOverlays[1] = vertexOverlays[3];
            vertexOverlays[0] = vertexOverlays[3];
            vertexUnderlays[2] = vertexUnderlays[3] = this.client.getScene().getUnderlayIds()[z][x][y];
            vertexUnderlays[1] = vertexUnderlays[3];
            vertexUnderlays[0] = vertexUnderlays[3];
            if (this.useDefaultColor(tile)) {
                vertexDefaultColor[3] = true;
                vertexDefaultColor[2] = true;
                vertexDefaultColor[1] = true;
                vertexDefaultColor[0] = true;
            }
        } else if (tile.getSceneTileModel() != null) {
            SceneTileModel sceneTileModel = tile.getSceneTileModel();
            int[] faceColorsA = sceneTileModel.getTriangleColorA();
            int[] faceColorsB = sceneTileModel.getTriangleColorB();
            int[] faceColorsC = sceneTileModel.getTriangleColorC();
            for (int face = 0; face < faceCount; ++face) {
                int[] faceColors = new int[]{faceColorsA[face], faceColorsB[face], faceColorsC[face]};
                int[] vertexKeys = this.faceVertexKeys(tile, face);
                for (int vertex = 0; vertex < 3; ++vertex) {
                    int color;
                    if (this.faceWaterType(tile, face, sceneTileModel) != WaterType.NONE) continue;
                    vertexHashes[face * 3 + vertex] = vertexKeys[vertex];
                    vertexColors[face * 3 + vertex] = color = faceColors[vertex];
                    if (this.isOverlayFace(tile, face)) {
                        vertexOverlays[face * 3 + vertex] = this.client.getScene().getOverlayIds()[z][x][y];
                    }
                    vertexUnderlays[face * 3 + vertex] = this.client.getScene().getUnderlayIds()[z][x][y];
                    if (!this.isOverlayFace(tile, face) || !this.useDefaultColor(tile)) continue;
                    vertexDefaultColor[face * 3 + vertex] = true;
                }
            }
        }
        for (int vertex = 0; vertex < vertexHashes.length; ++vertex) {
            if (vertexHashes[vertex] == 0 || vertexColors[vertex] < 0 || vertexColors[vertex] > 65535) continue;
            boolean lowPriorityColor = vertexColors[vertex] <= 2;
            int[] colorHSL = HDUtils.colorIntToHSL(vertexColors[vertex]);
            float lightenMultiplier = 1.5f;
            int lightenBase = 15;
            int lightenAdd = 3;
            float darkenMultiplier = 0.5f;
            int darkenBase = 0;
            int darkenAdd = 0;
            float[] vNormals = this.vertexTerrainNormals.getOrDefault(vertexHashes[vertex], new float[]{0.0f, 0.0f, 0.0f});
            float dot = HDUtils.dotNormal3Lights(vNormals, false);
            int lighten = (int)((float)Math.max(colorHSL[2] - lightenAdd, 0) * lightenMultiplier) + lightenBase;
            colorHSL[2] = (int)HDUtils.lerp(colorHSL[2], lighten, Math.max(dot, 0.0f));
            int darken = (int)((float)Math.max(colorHSL[2] - darkenAdd, 0) * darkenMultiplier) + darkenBase;
            colorHSL[2] = (int)HDUtils.lerp(colorHSL[2], darken, Math.abs(Math.min(dot, 0.0f)));
            colorHSL[2] = (int)((float)colorHSL[2] * 1.25f);
            boolean isOverlay = false;
            Material material = Material.DIRT_1;
            Overlay overlay = Overlay.getOverlay(vertexOverlays[vertex], tile, this.client, this.config);
            Underlay underlay = Underlay.getUnderlay(vertexUnderlays[vertex], tile, this.client, this.config);
            if (overlay != Overlay.NONE) {
                material = overlay.groundMaterial.getRandomMaterial(z, worldX, worldY);
                isOverlay = !overlay.blendedAsUnderlay;
                colorHSL = this.recolorOverlay(overlay, colorHSL);
            } else if (underlay != Underlay.NONE) {
                material = underlay.groundMaterial.getRandomMaterial(z, worldX, worldY);
                isOverlay = underlay.blendedAsOverlay;
                colorHSL = this.recolorUnderlay(underlay, colorHSL);
            }
            int maxBrightness = 55;
            colorHSL[2] = HDUtils.clamp(colorHSL[2], 0, 55);
            vertexColors[vertex] = HDUtils.colorHSLToInt(colorHSL);
            if (isOverlay) {
                this.vertexIsOverlay.put(vertexHashes[vertex], true);
            } else {
                this.vertexIsUnderlay.put(vertexHashes[vertex], true);
            }
            if (lowPriorityColor && this.highPriorityColor.containsKey(vertexHashes[vertex]) || vertexDefaultColor[vertex]) continue;
            if (vertexOverlays[vertex] != 0 || !this.vertexTerrainColor.containsKey(vertexHashes[vertex]) || !this.highPriorityColor.containsKey(vertexHashes[vertex])) {
                this.vertexTerrainColor.put(vertexHashes[vertex], vertexColors[vertex]);
            }
            if (vertexOverlays[vertex] != 0 || !this.vertexTerrainTexture.containsKey(vertexHashes[vertex]) || !this.highPriorityColor.containsKey(vertexHashes[vertex])) {
                this.vertexTerrainTexture.put(vertexHashes[vertex], material);
            }
            if (lowPriorityColor) continue;
            this.highPriorityColor.put(vertexHashes[vertex], true);
        }
    }

    public void generateUnderwaterTerrain(Scene scene) {
        int vY;
        int vX;
        int vertex;
        int y;
        int x;
        int z;
        this.tileIsWater = new boolean[4][104][104];
        this.vertexIsWater = new HashMap<Integer, Boolean>();
        this.vertexIsLand = new HashMap<Integer, Boolean>();
        this.skipTile = new boolean[4][104][104];
        this.vertexUnderwaterDepth = new HashMap<Integer, Integer>();
        this.underwaterDepthLevels = new int[4][105][105];
        int[][][] underwaterDepths = new int[4][105][105];
        Tile[][][] tiles = scene.getTiles();
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                Arrays.fill(this.underwaterDepthLevels[z][x], 1);
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    if (tiles[z][x][y] == null) {
                        this.underwaterDepthLevels[z][x][y] = 0;
                        this.underwaterDepthLevels[z][x + 1][y] = 0;
                        this.underwaterDepthLevels[z][x][y + 1] = 0;
                        this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                        continue;
                    }
                    Tile tile = tiles[z][x][y];
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int checkZ;
                        int n;
                        int[] vertexKeys = this.tileVertexKeys(tile);
                        if (this.tileWaterType(tile, tile.getSceneTilePaint()) == WaterType.NONE) {
                            int[] nArray = vertexKeys;
                            int n2 = nArray.length;
                            for (n = 0; n < n2; ++n) {
                                int vertexKey = nArray[n];
                                if (tile.getSceneTilePaint().getNeColor() == 12345678) continue;
                                this.vertexIsLand.put(vertexKey, true);
                            }
                            this.underwaterDepthLevels[z][x][y] = 0;
                            this.underwaterDepthLevels[z][x + 1][y] = 0;
                            this.underwaterDepthLevels[z][x][y + 1] = 0;
                            this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                            continue;
                        }
                        if (z > 0) {
                            boolean continueLoop = false;
                            for (checkZ = 0; checkZ < z; ++checkZ) {
                                if (!this.tileIsWater[checkZ][x][y]) continue;
                                this.underwaterDepthLevels[z][x][y] = 0;
                                this.underwaterDepthLevels[z][x + 1][y] = 0;
                                this.underwaterDepthLevels[z][x][y + 1] = 0;
                                this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                this.skipTile[z][x][y] = true;
                                continueLoop = true;
                                break;
                            }
                            if (continueLoop) continue;
                        }
                        this.tileIsWater[z][x][y] = true;
                        int[] continueLoop = vertexKeys;
                        checkZ = continueLoop.length;
                        for (n = 0; n < checkZ; ++n) {
                            int vertexKey = continueLoop[n];
                            this.vertexIsWater.put(vertexKey, true);
                        }
                        continue;
                    }
                    if (tile.getSceneTileModel() != null) {
                        SceneTileModel sceneTileModel = tile.getSceneTileModel();
                        int faceCount = sceneTileModel.getFaceX().length;
                        if (z > 0) {
                            boolean tileIncludesWater = false;
                            for (int face = 0; face < faceCount; ++face) {
                                if (this.faceWaterType(tile, face, sceneTileModel) == WaterType.NONE) continue;
                                tileIncludesWater = true;
                                break;
                            }
                            if (tileIncludesWater) {
                                boolean continueLoop = false;
                                for (int checkZ = 0; checkZ < z; ++checkZ) {
                                    if (!this.tileIsWater[checkZ][x][y]) continue;
                                    this.underwaterDepthLevels[z][x][y] = 0;
                                    this.underwaterDepthLevels[z][x + 1][y] = 0;
                                    this.underwaterDepthLevels[z][x][y + 1] = 0;
                                    this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                    this.skipTile[z][x][y] = true;
                                    continueLoop = true;
                                    break;
                                }
                                if (continueLoop) continue;
                            }
                        }
                        for (int face = 0; face < faceCount; ++face) {
                            int[][] vertices = this.faceVertices(tile, face);
                            int[] vertexKeys = this.faceVertexKeys(tile, face);
                            if (this.faceWaterType(tile, face, sceneTileModel) == WaterType.NONE) {
                                for (vertex = 0; vertex < 3; ++vertex) {
                                    if (sceneTileModel.getTriangleColorA()[face] != 12345678) {
                                        this.vertexIsLand.put(vertexKeys[vertex], true);
                                    }
                                    if (vertices[vertex][0] % 128 != 0 || vertices[vertex][1] % 128 != 0) continue;
                                    vX = vertices[vertex][0] / 128;
                                    vY = vertices[vertex][1] / 128;
                                    this.underwaterDepthLevels[z][vX][vY] = 0;
                                }
                                continue;
                            }
                            this.tileIsWater[z][x][y] = true;
                            for (vertex = 0; vertex < 3; ++vertex) {
                                this.vertexIsWater.put(vertexKeys[vertex], true);
                            }
                        }
                        continue;
                    }
                    this.underwaterDepthLevels[z][x][y] = 0;
                    this.underwaterDepthLevels[z][x + 1][y] = 0;
                    this.underwaterDepthLevels[z][x][y + 1] = 0;
                    this.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                }
            }
        }
        for (int level = 0; level < this.depthLevelSlope.length - 1; ++level) {
            for (int z2 = 0; z2 < 4; ++z2) {
                for (int x2 = 0; x2 < this.underwaterDepthLevels[z2].length; ++x2) {
                    for (int y2 = 0; y2 < this.underwaterDepthLevels[z2][x2].length; ++y2) {
                        if (this.underwaterDepthLevels[z2][x2][y2] == 0) continue;
                        if (x2 == 0 || y2 == 0 || x2 == 104 || y2 == 104) {
                            this.underwaterDepthLevels[z2][x2][y2] = 0;
                            continue;
                        }
                        int tileHeight = this.underwaterDepthLevels[z2][x2][y2];
                        if (this.underwaterDepthLevels[z2][x2 - 1][y2] < tileHeight || x2 < this.underwaterDepthLevels[z2].length - 1 && this.underwaterDepthLevels[z2][x2 + 1][y2] < tileHeight || this.underwaterDepthLevels[z2][x2][y2 - 1] < tileHeight || y2 < this.underwaterDepthLevels[z2].length - 1 && this.underwaterDepthLevels[z2][x2][y2 + 1] < tileHeight) continue;
                        int[] nArray = this.underwaterDepthLevels[z2][x2];
                        int n = y2;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < this.underwaterDepthLevels[z].length; ++x) {
                for (y = 0; y < this.underwaterDepthLevels[z][x].length; ++y) {
                    int heightOffset;
                    if (this.underwaterDepthLevels[z][x][y] == 0) continue;
                    int maxRange = this.depthLevelSlope[this.underwaterDepthLevels[z][x][y] - 1];
                    int minRange = (int)((float)this.depthLevelSlope[this.underwaterDepthLevels[z][x][y] - 1] * 0.1f);
                    float noiseOffset = 0.5f;
                    float minOffset = 0.25f;
                    float maxOffset = 0.75f;
                    noiseOffset = HDUtils.lerp(minOffset, maxOffset, noiseOffset);
                    underwaterDepths[z][x][y] = heightOffset = (int)HDUtils.lerp(minRange, maxRange, noiseOffset);
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 104; ++x) {
                for (y = 0; y < 104; ++y) {
                    Tile tile;
                    if (!this.tileIsWater[z][x][y] || (tile = tiles[z][x][y]) == null) continue;
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int[] vertexKeys = this.tileVertexKeys(tile);
                        int swVertexKey = vertexKeys[0];
                        int seVertexKey = vertexKeys[1];
                        int nwVertexKey = vertexKeys[2];
                        int neVertexKey = vertexKeys[3];
                        this.vertexUnderwaterDepth.put(swVertexKey, underwaterDepths[z][x][y]);
                        this.vertexUnderwaterDepth.put(seVertexKey, underwaterDepths[z][x + 1][y]);
                        this.vertexUnderwaterDepth.put(nwVertexKey, underwaterDepths[z][x][y + 1]);
                        this.vertexUnderwaterDepth.put(neVertexKey, underwaterDepths[z][x + 1][y + 1]);
                        continue;
                    }
                    if (tile.getSceneTileModel() == null) continue;
                    SceneTileModel sceneTileModel = tile.getSceneTileModel();
                    int faceCount = sceneTileModel.getFaceX().length;
                    for (int face = 0; face < faceCount; ++face) {
                        int[][] vertices = this.faceVertices(tile, face);
                        int[] vertexKeys = this.faceVertexKeys(tile, face);
                        for (vertex = 0; vertex < 3; ++vertex) {
                            if (vertices[vertex][0] % 128 == 0 && vertices[vertex][1] % 128 == 0) {
                                vX = vertices[vertex][0] / 128;
                                vY = vertices[vertex][1] / 128;
                                this.vertexUnderwaterDepth.put(vertexKeys[vertex], underwaterDepths[z][vX][vY]);
                                continue;
                            }
                            int localVertexX = vertices[vertex][0] - x * 128;
                            int localVertexY = vertices[vertex][1] - y * 128;
                            float lerpX = (float)localVertexX / 128.0f;
                            float lerpY = (float)localVertexY / 128.0f;
                            float northHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y + 1], underwaterDepths[z][x + 1][y + 1], lerpX);
                            float southHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y], underwaterDepths[z][x + 1][y], lerpX);
                            int heightOffset = (int)HDUtils.lerp(southHeightOffset, northHeightOffset, lerpY);
                            if (this.vertexIsLand.containsKey(vertexKeys[vertex])) continue;
                            this.vertexUnderwaterDepth.put(vertexKeys[vertex], heightOffset);
                        }
                    }
                }
            }
        }
    }

    public void calculateTerrainNormals(Scene scene) {
        Tile[][][] tiles;
        this.vertexTerrainNormals = new HashMap<Integer, float[]>();
        Tile[][][] tileArray = tiles = scene.getTiles();
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[][] plane;
            Tile[][] tileArray2 = plane = tileArray[i];
            int n2 = tileArray2.length;
            for (int j = 0; j < n2; ++j) {
                Tile[] column;
                for (Tile tile : column = tileArray2[j]) {
                    if (tile == null) continue;
                    boolean isBridge = false;
                    if (tile.getBridge() != null) {
                        this.calculateNormalsForTile(tile.getBridge(), false);
                        isBridge = true;
                    }
                    this.calculateNormalsForTile(tile, isBridge);
                }
            }
        }
    }

    void calculateNormalsForTile(Tile tile, boolean isBridge) {
        int[][] faceVertexKeys;
        int[][][] faceVertices;
        if (tile.getSceneTileModel() != null) {
            SceneTileModel tileModel = tile.getSceneTileModel();
            faceVertices = new int[tileModel.getFaceX().length][3][3];
            faceVertexKeys = new int[tileModel.getFaceX().length][3];
            for (int face = 0; face < tileModel.getFaceX().length; ++face) {
                int[][] vertices = this.faceVertices(tile, face);
                faceVertices[face][0] = new int[]{vertices[0][0], vertices[0][1], vertices[0][2]};
                faceVertices[face][2] = new int[]{vertices[1][0], vertices[1][1], vertices[1][2]};
                faceVertices[face][1] = new int[]{vertices[2][0], vertices[2][1], vertices[2][2]};
                int[] vertexKeys = this.faceVertexKeys(tile, face);
                faceVertexKeys[face][0] = vertexKeys[0];
                faceVertexKeys[face][2] = vertexKeys[1];
                faceVertexKeys[face][1] = vertexKeys[2];
            }
        } else {
            faceVertices = new int[2][3][3];
            faceVertexKeys = new int[3][3];
            int[][] vertices = this.tileVertices(tile);
            faceVertices[0] = new int[][]{vertices[3], vertices[1], vertices[2]};
            faceVertices[1] = new int[][]{vertices[0], vertices[2], vertices[1]};
            int[] vertexKeys = this.tileVertexKeys(tile);
            faceVertexKeys[0] = new int[]{vertexKeys[3], vertexKeys[1], vertexKeys[2]};
            faceVertexKeys[1] = new int[]{vertexKeys[0], vertexKeys[2], vertexKeys[1]};
        }
        for (int face = 0; face < faceVertices.length; ++face) {
            int[] vertexHeights = new int[]{faceVertices[face][0][2], faceVertices[face][1][2], faceVertices[face][2][2]};
            if (!isBridge) {
                vertexHeights[0] = vertexHeights[0] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][0], 0);
                vertexHeights[1] = vertexHeights[1] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][1], 0);
                vertexHeights[2] = vertexHeights[2] + this.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][2], 0);
            }
            float[] vertexNormals = HDUtils.calculateSurfaceNormals(new int[]{faceVertices[face][0][0], faceVertices[face][1][0], faceVertices[face][2][0]}, new int[]{faceVertices[face][0][1], faceVertices[face][1][1], faceVertices[face][2][1]}, new int[]{vertexHeights[0], vertexHeights[1], vertexHeights[2]});
            for (int vertex = 0; vertex < 3; ++vertex) {
                int vertexKey = faceVertexKeys[face][vertex];
                this.vertexTerrainNormals.merge(vertexKey, vertexNormals, (a, b) -> HDUtils.vectorAdd(b, a));
            }
        }
    }

    WaterType tileWaterType(Tile tile, SceneTilePaint sceneTilePaint) {
        if (tile.getBridge() != null) {
            return WaterType.NONE;
        }
        int tileZ = tile.getRenderLevel();
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        WaterType waterType = WaterType.NONE;
        if (sceneTilePaint != null) {
            Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
            if (overlay != Overlay.NONE) {
                waterType = overlay.waterType;
            } else {
                Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                waterType = underlay.waterType;
            }
        }
        waterType = this.getSeasonalWaterType(waterType);
        return waterType;
    }

    WaterType faceWaterType(Tile tile, int face, SceneTileModel sceneTileModel) {
        if (tile.getBridge() != null) {
            return WaterType.NONE;
        }
        int tileZ = tile.getRenderLevel();
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        WaterType waterType = WaterType.NONE;
        if (sceneTileModel != null) {
            Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
            if (this.isOverlayFace(tile, face) && overlay != Overlay.NONE) {
                waterType = overlay.waterType;
            } else {
                Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[tileZ][tileX][tileY]), tile, this.client, this.config);
                waterType = underlay.waterType;
            }
        }
        waterType = this.getSeasonalWaterType(waterType);
        return waterType;
    }

    boolean[] getTileOverlayTris(int tileShapeIndex) {
        if (tileShapeIndex >= this.tileOverlayTris.length) {
            log.debug("getTileOverlayTris(): unknown tileShapeIndex ({})", (Object)tileShapeIndex);
            return new boolean[10];
        }
        return this.tileOverlayTris[tileShapeIndex];
    }

    public boolean isOverlayFace(Tile tile, int face) {
        int tileShapeIndex = tile.getSceneTileModel().getShape() - 1;
        if (face >= this.getTileOverlayTris(tileShapeIndex).length) {
            return false;
        }
        return this.getTileOverlayTris(tileShapeIndex)[face];
    }

    int[][] tileVertices(Tile tile) {
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int z = tile.getRenderLevel();
        int[][][] tileHeights = this.client.getTileHeights();
        int[] swVertex = new int[]{x * 128, y * 128, tileHeights[z][x][y]};
        int[] seVertex = new int[]{(x + 1) * 128, y * 128, tileHeights[z][x + 1][y]};
        int[] nwVertex = new int[]{x * 128, (y + 1) * 128, tileHeights[z][x][y + 1]};
        int[] neVertex = new int[]{(x + 1) * 128, (y + 1) * 128, tileHeights[z][x + 1][y + 1]};
        return new int[][]{swVertex, seVertex, nwVertex, neVertex};
    }

    int[][] faceVertices(Tile tile, int face) {
        SceneTileModel sceneTileModel = tile.getSceneTileModel();
        int[] faceA = sceneTileModel.getFaceX();
        int[] faceB = sceneTileModel.getFaceY();
        int[] faceC = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int vertexFacesA = faceA[face];
        int vertexFacesB = faceB[face];
        int vertexFacesC = faceC[face];
        int sceneVertexXA = vertexX[vertexFacesA];
        int sceneVertexXB = vertexX[vertexFacesB];
        int sceneVertexXC = vertexX[vertexFacesC];
        int sceneVertexZA = vertexZ[vertexFacesA];
        int sceneVertexZB = vertexZ[vertexFacesB];
        int sceneVertexZC = vertexZ[vertexFacesC];
        int sceneVertexYA = vertexY[vertexFacesA];
        int sceneVertexYB = vertexY[vertexFacesB];
        int sceneVertexYC = vertexY[vertexFacesC];
        int[] vertexA = new int[]{sceneVertexXA, sceneVertexZA, sceneVertexYA};
        int[] vertexB = new int[]{sceneVertexXB, sceneVertexZB, sceneVertexYB};
        int[] vertexC = new int[]{sceneVertexXC, sceneVertexZC, sceneVertexYC};
        return new int[][]{vertexA, vertexB, vertexC};
    }

    int[][] faceLocalVertices(Tile tile, int face) {
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int baseX = x * 128;
        int baseY = y * 128;
        if (tile.getSceneTileModel() == null) {
            return new int[0][0];
        }
        SceneTileModel sceneTileModel = tile.getSceneTileModel();
        int[] faceA = sceneTileModel.getFaceX();
        int[] faceB = sceneTileModel.getFaceY();
        int[] faceC = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int vertexFacesA = faceA[face];
        int vertexFacesB = faceB[face];
        int vertexFacesC = faceC[face];
        int sceneVertexXA = vertexX[vertexFacesA];
        int sceneVertexXB = vertexX[vertexFacesB];
        int sceneVertexXC = vertexX[vertexFacesC];
        int sceneVertexZA = vertexZ[vertexFacesA];
        int sceneVertexZB = vertexZ[vertexFacesB];
        int sceneVertexZC = vertexZ[vertexFacesC];
        int sceneVertexYA = vertexY[vertexFacesA];
        int sceneVertexYB = vertexY[vertexFacesB];
        int sceneVertexYC = vertexY[vertexFacesC];
        int[] vertexA = new int[]{sceneVertexXA - baseX, sceneVertexZA - baseY, sceneVertexYA};
        int[] vertexB = new int[]{sceneVertexXB - baseX, sceneVertexZB - baseY, sceneVertexYB};
        int[] vertexC = new int[]{sceneVertexXC - baseX, sceneVertexZC - baseY, sceneVertexYC};
        return new int[][]{vertexA, vertexB, vertexC};
    }

    int[] tileVertexKeys(Tile tile) {
        int[][] tileVertices = this.tileVertices(tile);
        int[] vertexHashes = new int[tileVertices.length];
        for (int vertex = 0; vertex < tileVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(tileVertices[vertex]);
        }
        return vertexHashes;
    }

    int[] faceVertexKeys(Tile tile, int face) {
        int[][] faceVertices = this.faceVertices(tile, face);
        int[] vertexHashes = new int[faceVertices.length];
        for (int vertex = 0; vertex < faceVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(faceVertices[vertex]);
        }
        return vertexHashes;
    }

    public int[] recolorOverlay(Overlay overlay, int[] colorHSL) {
        colorHSL[0] = overlay.hue >= 0 ? overlay.hue : colorHSL[0];
        colorHSL[0] = colorHSL[0] + overlay.shiftHue;
        colorHSL[0] = HDUtils.clamp(colorHSL[0], 0, 63);
        colorHSL[1] = overlay.saturation >= 0 ? overlay.saturation : colorHSL[1];
        colorHSL[1] = colorHSL[1] + overlay.shiftSaturation;
        colorHSL[1] = HDUtils.clamp(colorHSL[1], 0, 7);
        colorHSL[2] = overlay.lightness >= 0 ? overlay.lightness : colorHSL[2];
        colorHSL[2] = colorHSL[2] + overlay.shiftLightness;
        colorHSL[2] = HDUtils.clamp(colorHSL[2], 0, 127);
        return colorHSL;
    }

    public int[] recolorUnderlay(Underlay underlay, int[] colorHSL) {
        colorHSL[0] = underlay.hue >= 0 ? underlay.hue : colorHSL[0];
        colorHSL[0] = colorHSL[0] + underlay.shiftHue;
        colorHSL[0] = HDUtils.clamp(colorHSL[0], 0, 63);
        colorHSL[1] = underlay.saturation >= 0 ? underlay.saturation : colorHSL[1];
        colorHSL[1] = colorHSL[1] + underlay.shiftSaturation;
        colorHSL[1] = HDUtils.clamp(colorHSL[1], 0, 7);
        colorHSL[2] = underlay.lightness >= 0 ? underlay.lightness : colorHSL[2];
        colorHSL[2] = colorHSL[2] + underlay.shiftLightness;
        colorHSL[2] = HDUtils.clamp(colorHSL[2], 0, 127);
        return colorHSL;
    }

    boolean useDefaultColor(Tile tile) {
        int z = tile.getRenderLevel();
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        if (tile.getSceneTilePaint() != null && tile.getSceneTilePaint().getTexture() >= 0 || tile.getSceneTileModel() != null && tile.getSceneTileModel().getTriangleTextureId() != null) {
            return true;
        }
        Overlay overlay = Overlay.getOverlay(Integer.valueOf(this.client.getScene().getOverlayIds()[z][x][y]), tile, this.client, this.config);
        if (overlay != Overlay.NONE) {
            return !overlay.blended;
        }
        Underlay underlay = Underlay.getUnderlay(Integer.valueOf(this.client.getScene().getUnderlayIds()[z][x][y]), tile, this.client, this.config);
        if (underlay != Underlay.NONE) {
            return !underlay.blended;
        }
        return false;
    }

    WaterType getSeasonalWaterType(WaterType waterType) {
        if (this.plugin.configWinterTheme && waterType == WaterType.WATER) {
            return WaterType.ICE;
        }
        return waterType;
    }

    public int[][] recolorTzHaar(ModelOverride modelOverride, int aY, int bY, int cY, int packedAlphaPriority, ObjectType objectType, int color1S, int color1L, int color2S, int color2L, int color3S, int color3L) {
        int hue;
        if (objectType == ObjectType.GROUND_OBJECT && color1S <= 1) {
            packedAlphaPriority = -16777216;
        }
        int color1H = hue = 7;
        int color2H = hue;
        int color3H = hue;
        if (modelOverride.tzHaarRecolorType == TzHaarRecolorType.GRADIENT) {
            float pos;
            if (color1L < 20) {
                pos = HDUtils.clamp((float)(aY - -200) / 200.0f, 0.0f, 1.0f);
                color1H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color1S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color1L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
            if (color2L < 20) {
                pos = HDUtils.clamp((float)(bY - -200) / 200.0f, 0.0f, 1.0f);
                color2H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color2S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color2L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
            if (color3L < 20) {
                pos = HDUtils.clamp((float)(cY - -200) / 200.0f, 0.0f, 1.0f);
                color3H = (int)HDUtils.lerp(this.gradientDarkColor[0], this.gradientBaseColor[0], pos);
                color3S = (int)HDUtils.lerp(this.gradientDarkColor[1], this.gradientBaseColor[1], pos);
                color3L = (int)HDUtils.lerp(this.gradientDarkColor[2], this.gradientBaseColor[2], pos);
            }
        } else if (modelOverride.tzHaarRecolorType == TzHaarRecolorType.HUE_SHIFT) {
            // empty if block
        }
        this.tzHaarRecolored[0][0] = color1H;
        this.tzHaarRecolored[0][1] = color1S;
        this.tzHaarRecolored[0][2] = ++color1L;
        this.tzHaarRecolored[1][0] = color2H;
        this.tzHaarRecolored[1][1] = color2S;
        this.tzHaarRecolored[1][2] = ++color2L;
        this.tzHaarRecolored[2][0] = color3H;
        this.tzHaarRecolored[2][1] = color3S;
        this.tzHaarRecolored[2][2] = ++color3L;
        this.tzHaarRecolored[3][0] = packedAlphaPriority;
        return this.tzHaarRecolored;
    }
}

