/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;

public class DuelHudOverlay
extends RSInterface {
    public static final int DUEL_OVERLAY = 33469;
    public static final int LEFT_NAME = 33470;
    public static final int RIGHT_NAME = 33471;
    public static final int STAGE_TEXT = 33472;
    public static final int LEFT_BAR = 33473;
    public static final int RIGHT_BAR = 33474;
    public static final int VARP_LEFT_COLOR = 1316;
    public static final int VARP_RIGHT_COLOR = 1317;
    public static final int VARP_LEFT_HEALTH = 1310;
    public static final int VARP_RIGHT_HEALTH = 1311;
    public static final int VARP_STAGE_INDEX = 1315;
    private static int anchorX;
    private static int baseY;
    private static final int barW = 160;
    private static final int barH = 18;

    public static void duelOverlay(TextDrawingArea[] tda) {
        RSInterface root = DuelHudOverlay.addInterface(33469);
        root.id = 33469;
        root.parentID = 33469;
        root.interfaceHidden = true;
        DuelHudOverlay.addTextTDA(33470, "Left", tda, 1, 16252462, false, true, 33469);
        DuelHudOverlay.addTextTDA(33471, "Right", tda, 1, 16252462, true, true, 33469);
        DuelHudOverlay.addTextTDA(33472, "", tda, 1, 0xFFFFFF, true, true, 33469);
        RSInterface leftBar = DuelHudOverlay.addProgressBar(33473, 160, 18, 2221, 10400);
        RSInterface rightBar = DuelHudOverlay.addProgressBar(33474, 160, 18, 2221, 10400);
        leftBar.parentID = 33469;
        rightBar.parentID = 33469;
        leftBar.fillColor = 65535;
        leftBar.progressBackColor = 0xC8C8C8;
        leftBar.progressBackAlpha = 255;
        rightBar.fillColor = 14604050;
        rightBar.progressBackColor = 0xC8C8C8;
        rightBar.progressBackAlpha = 255;
        DuelHudOverlay.initBar(leftBar);
        DuelHudOverlay.initBar(rightBar);
        DuelHudOverlay.computeAnchors();
        DuelHudOverlay.setChildren(5, root);
        DuelHudOverlay.applyChildrenLayout(root);
        DuelHudOverlay.setVisible(false);
    }

    public static void reposition() {
        RSInterface root = RSInterface.interfaceCache[33469];
        if (root == null) {
            return;
        }
        DuelHudOverlay.computeAnchors();
        DuelHudOverlay.applyChildrenLayout(root);
    }

    private static void computeAnchors() {
        if (!Client.instance.isResized()) {
            anchorX = 210;
            baseY = 12;
            return;
        }
        baseY = 12;
    }

    private static void applyChildrenLayout(RSInterface root) {
        if (!Client.instance.isResized()) {
            root.child(0, 33470, anchorX - 65, baseY - 2);
            root.child(1, 33471, anchorX + 160 - 135, baseY - 2);
            root.child(2, 33473, anchorX - 115, baseY + 16);
            root.child(3, 33474, anchorX + 50, baseY + 16);
            root.child(4, 33472, 155, baseY + 40);
            return;
        }
        int centerX = Client.canvasWidth / 2;
        int gap = 30;
        int topY = baseY;
        int leftBarX = centerX - 15 - 160;
        int rightBarX = centerX + 15;
        int leftNameX = leftBarX + 50;
        int rightNameX = rightBarX - 25;
        int stageX = centerX - 100;
        root.child(0, 33470, leftNameX, topY - 2);
        root.child(1, 33471, rightNameX, topY - 2);
        root.child(2, 33473, leftBarX, topY + 16);
        root.child(3, 33474, rightBarX, topY + 16);
        root.child(4, 33472, stageX, topY + 40);
    }

    private static void initBar(RSInterface bar) {
        bar.maxValue = 1;
        bar.value = 0;
        bar.message = "0/0";
        bar.interfaceHidden = false;
    }

    public static void setVisible(boolean show) {
        RSInterface r = RSInterface.interfaceCache[33469];
        if (r != null) {
            r.interfaceHidden = !show;
        }
        DuelHudOverlay.toggleChildHidden(33470, !show);
        DuelHudOverlay.toggleChildHidden(33471, !show);
        DuelHudOverlay.toggleChildHidden(33472, !show);
        DuelHudOverlay.toggleChildHidden(33473, !show);
        DuelHudOverlay.toggleChildHidden(33474, !show);
    }

    private static void toggleChildHidden(int id, boolean hidden) {
        RSInterface c = RSInterface.interfaceCache[id];
        if (c != null) {
            c.interfaceHidden = hidden;
        }
    }

    public static void onVarpChange(int id, int value) {
        if (id == 1310) {
            int cur = value & 0xFFFF;
            int max = value >>> 16 & 0xFFFF;
            DuelHudOverlay.applyBar(33473, cur, max);
        } else if (id == 1311) {
            int cur = value & 0xFFFF;
            int max = value >>> 16 & 0xFFFF;
            DuelHudOverlay.applyBar(33474, cur, max);
        } else if (id == 1315) {
            if (value >= 1 && value < 99) {
                DuelHudOverlay.setVisible(true);
            } else {
                DuelHudOverlay.setVisible(false);
            }
        } else if (id == 1316) {
            DuelHudOverlay.setBarColor(33473, value);
        } else if (id == 1317) {
            DuelHudOverlay.setBarColor(33474, value);
        }
    }

    private static void setBarColor(int barId, int code) {
        int color;
        RSInterface bar = RSInterface.interfaceCache[barId];
        if (bar == null) {
            return;
        }
        bar.fillColor = color = code == 1 ? 0xFF0000 : (code == 2 ? 3833343 : (code == 3 ? 3977283 : (code == 4 ? 16747520 : (code == 5 ? 14604050 : 65535))));
    }

    public static void setStage(String s2) {
        RSInterface t = RSInterface.interfaceCache[33472];
        if (t != null) {
            t.message = s2 == null ? "" : s2;
        }
    }

    private static void applyBar(int id, int cur, int max) {
        RSInterface bar = RSInterface.interfaceCache[id];
        if (bar == null) {
            return;
        }
        if (max < 1) {
            max = 1;
        }
        if (cur < 0) {
            cur = 0;
        }
        if (cur > max) {
            cur = max;
        }
        bar.maxValue = max;
        bar.value = cur;
        bar.message = cur + "/" + max;
    }

    private static void addTextTDA(int id, String text, TextDrawingArea[] tda, int idx, int color, boolean centered, boolean shadow, int parent) {
        RSInterface rsi = DuelHudOverlay.addInterface(id);
        rsi.parentID = parent;
        rsi.id = id;
        rsi.type = 4;
        rsi.atActionType = 0;
        rsi.width = 200;
        rsi.height = 14;
        rsi.centerText = centered;
        rsi.textShadow = shadow;
        rsi.textDrawingAreas = tda[idx];
        rsi.textColor = color;
        rsi.message = text == null ? "" : text;
        rsi.interfaceHidden = false;
    }
}

