/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Configuration;
import com.client.Sprite;
import com.client.connection.Connection;
import com.client.graphics.interfaces.RSInterface;

public class StarterInterface
extends RSInterface {
    private static final StarterInterface INSTANCE = new StarterInterface();
    private static final int INTERFACE_ID = 24303;
    private Sprite bg = new Sprite("starter_interface/BACKGROUND");
    private Sprite line = new Sprite("starter_interface/LINE");
    private Sprite thumb = new Sprite("starter_interface/THUMB");
    private Sprite button = new Sprite("starter_interface/button");
    private Sprite buttonSelected = new Sprite("starter_interface/button_selected");
    private static final String MODE_HEADER_COLOUR = "<col=-1>";
    private static final String MODE_DESC_COLOUR = " <col=16750899>";
    private String[] GAME_MODES = new String[]{"Standard Mode\\nThe standard OblivionPk experience.", "Ironman Mode\\nAn Iron Man cannot trade, stake, receive PK loot, \\nor scavenge dropped items.", "Hardcore Ironman\\nIn addition to the standard Iron Man rules, Hardcore\\nhas 1 life. A dangerous death will result in being\\ndowngraded to a standard Iron Man.", "Ultimate Ironman\\nIn addition to the standard Iron Man rules, an\\nUltimate Iron Man cannot use banks.", "Group Ironman\\nYou'll be taken to a closed area where you can\\nSelect a group to play with in Ironman mode.\\nYou'll be able to trade and share resources.", "Wildyman Mode\\n10% extra DropRate, Locked to Wilderness.\\nconstant white skull.\\n(Changeable stats when maxed in specific skill).", "Hardcore Wildyman Mode\\n25% extra DropRate, Locked to Wilderness.\\nconstant red skull.\\n(Changeable stats when maxed in specific skill)."};
    private String[] W2GAME_MODES = new String[]{"Standard Mode\\nThe standard OblivionPk experience.", "Ironman Mode\\nAn Iron Man cannot trade, stake, receive PK loot, \\nor scavenge dropped items.", "Hardcore Ironman\\nIn addition to the standard Iron Man rules, Hardcore\\nhas 1 life. A dangerous death will result in being\\ndowngraded to a standard Iron Man.", "Ultimate Ironman\\nIn addition to the standard Iron Man rules, an\\nUltimate Iron Man cannot use banks.", "Group Ironman\\nYou'll be taken to a closed area where you can\\nSelect a group to play with in Ironman mode.\\nYou'll be able to trade and share resources.", "Wildyman Mode\\n10% extra DropRate, Locked to Wilderness.\\nconstant white skull.\\n(Changeable stats when maxed in specific skill).", "Hardcore Wildyman Mode\\n25% extra DropRate, Locked to Wilderness.\\nconstant red skull.\\n(Changeable stats when maxed in specific skill)."};

    public static StarterInterface get() {
        return INSTANCE;
    }

    private StarterInterface() {
    }

    public void load() {
        int interfaceId = 24303;
        int childId = 0;
        RSInterface inter = StarterInterface.addInterface(interfaceId++);
        inter.totalChildren(5);
        StarterInterface.addSprite(interfaceId, this.bg);
        inter.child(childId++, interfaceId++, 20, 24);
        StarterInterface.addText(interfaceId, 2, 0xFF9933, true, "Game Mode Setup");
        inter.child(childId++, interfaceId++, 248, 34);
        int buttonX = 194;
        int buttonY = 278;
        StarterInterface.addClickableText(interfaceId, "Confirm", "Choose", RSInterface.defaultTextDrawingAreas, 1, 16750623, false, false, 60, 16);
        inter.child(childId++, interfaceId++, buttonX, buttonY);
        StarterInterface.addSprite(interfaceId, this.thumb);
        inter.child(childId++, interfaceId++, buttonX - 22, buttonY - 4);
        inter.child(childId++, interfaceId, 46, 84);
        interfaceId = this.loadContainer(interfaceId);
    }

    private int loadContainer(int interfaceId) {
        String[] mode = this.GAME_MODES;
        if (Configuration.CONNECTION.equals((Object)Connection.WORLD_1)) {
            mode = this.W2GAME_MODES;
        }
        RSInterface inter = StarterInterface.addInterface(interfaceId++);
        inter.width = 303;
        inter.height = 189;
        inter.scrollMax = inter.height + 8 + (mode.length > 4 ? (mode.length - 4) * 46 : 0);
        inter.totalChildren(mode.length * 3);
        int childId = 0;
        for (int index = 0; index < mode.length; ++index) {
            int y = index * 47;
            StarterInterface.addConfigButton(interfaceId, this.button, this.buttonSelected, "Select mode", index, 1372, 4);
            StarterInterface.get((int)interfaceId).ignoreConfigClicking = true;
            inter.child(childId++, interfaceId++, 12, y + 12);
            StarterInterface.addSprite(interfaceId, this.line);
            inter.child(childId++, interfaceId++, 4, y + 46);
            StarterInterface.addText(interfaceId, 0, 0xFF9933, false, this.format(mode[index]));
            inter.child(childId++, interfaceId++, 36, y + 4);
        }
        return interfaceId;
    }

    private String format(String gameModeString) {
        String[] split = gameModeString.split("\\n");
        StringBuilder formattedString = new StringBuilder();
        for (int index = 0; index < split.length; ++index) {
            if (index == 0) {
                formattedString.append(MODE_HEADER_COLOUR).append(split[0]).append("\\n");
                continue;
            }
            formattedString.append(MODE_DESC_COLOUR).append(split[index]).append("\\n");
        }
        return formattedString.toString();
    }
}

