/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index.archive;

import com.displee.cache.compress.type.BZIP2Compressor;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.compress.type.GZIPCompressor;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/displee/cache/index/archive/Archive317;", "Lcom/displee/cache/index/archive/Archive;", "id", "", "(I)V", "name", "(II)V", "extracted", "", "read", "", "buffer", "Lcom/displee/io/impl/InputBuffer;", "toHash", "", "write", "", "rs-cache-library"})
public final class Archive317
extends Archive {
    private boolean extracted;

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(@NotNull InputBuffer buffer) {
        int compressedLength;
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.setRead(true);
        if (this.getCompressionType() == CompressionType.GZIP) {
            ((Map)this.getFiles()).put(0, new File(0, GZIPCompressor.INSTANCE.deflate317(buffer.raw()), 0, 4, null));
            return;
        }
        byte[] decompressed = null;
        int decompressedLength = buffer.read24BitInt();
        if (decompressedLength != (compressedLength = buffer.read24BitInt())) {
            byte[] byArray = BZIP2Compressor.decompress317(decompressedLength, compressedLength, buffer);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "BZIP2Compressor.decompre\u2026compressedLength, buffer)");
            decompressed = byArray;
            this.extracted = true;
        } else {
            decompressed = buffer.readBytes(buffer.remaining());
        }
        InputBuffer metaBuffer = new InputBuffer(decompressed);
        int filesLength = metaBuffer.readUnsignedShort();
        InputBuffer filesBuffer = new InputBuffer(decompressed);
        filesBuffer.setOffset(metaBuffer.getOffset() + filesLength * 10);
        int n = 0;
        int n2 = filesLength;
        while (n < n2) {
            void i;
            byte[] byArray;
            int fileName = metaBuffer.readInt();
            decompressedLength = metaBuffer.read24BitInt();
            compressedLength = metaBuffer.read24BitInt();
            if (this.extracted) {
                byArray = filesBuffer.readBytes(decompressedLength);
            } else {
                byte[] byArray2 = BZIP2Compressor.decompress317(decompressedLength, compressedLength, filesBuffer);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull(byArray2, "BZIP2Compressor.decompre\u2026essedLength, filesBuffer)");
            }
            byte[] data2 = byArray;
            ((Map)this.getFiles()).put((int)i, new File((int)i, data2, fileName));
            ++i;
        }
    }

    @Override
    @NotNull
    public byte[] write() {
        block5: {
            Object object;
            block7: {
                block6: {
                    if (this.getCompressionType() != CompressionType.GZIP) break block5;
                    object = this.first();
                    if (object == null) break block6;
                    byte[] byArray = ((File)object).getData();
                    object = byArray;
                    if (byArray != null) break block7;
                }
                object = new byte[0];
            }
            return GZIPCompressor.INSTANCE.inflate317((byte[])object);
        }
        OutputBuffer metaBuffer = new OutputBuffer(2 + this.getFiles().size() * 10);
        metaBuffer.writeShort(this.getFiles().size());
        OutputBuffer filesBuffer = new OutputBuffer(2048);
        for (File file : this.getFiles().values()) {
            byte[] fileData;
            if (file.getData() == null) {
                continue;
            }
            metaBuffer.writeInt(file.getHashName()).write24BitInt(fileData.length);
            byte[] toWrite = this.extracted ? fileData : BZIP2Compressor.compress(file.getData());
            metaBuffer.write24BitInt(toWrite.length);
            Intrinsics.checkExpressionValueIsNotNull(toWrite, "toWrite");
            filesBuffer.writeBytes(toWrite);
        }
        metaBuffer.writeBytes(Buffer.array$default(filesBuffer, 0, 0, 3, null));
        byte[] decompressed = Buffer.array$default(metaBuffer, 0, 0, 3, null);
        byte[] compressed = this.extracted ? BZIP2Compressor.compress(decompressed) : decompressed;
        OutputBuffer buffer = new OutputBuffer(compressed.length + 6);
        OutputBuffer outputBuffer = buffer.write24BitInt(decompressed.length).write24BitInt(compressed.length);
        Intrinsics.checkExpressionValueIsNotNull(compressed, "compressed");
        outputBuffer.writeBytes(compressed);
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    @Override
    public int toHash(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return OtherExtKt.hashCode317(name);
    }

    public Archive317(int id, int name) {
        super(id, name, null, 4, null);
    }

    public Archive317(int id) {
        this(id, 0);
    }
}

