/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.SessionClient;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClientSessionManager {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionManager.class);
    private final ScheduledExecutorService executorService;
    private final Client client;
    private final SessionClient sessionClient;
    private ScheduledFuture<?> scheduledFuture;
    private UUID sessionId;

    @Inject
    ClientSessionManager(ScheduledExecutorService executorService, @Nullable Client client, SessionClient sessionClient) {
        this.executorService = executorService;
        this.client = client;
        this.sessionClient = sessionClient;
    }

    public void start() {
    }

    @Subscribe
    private void onClientShutdown(ClientShutdown e) {
        if (this.scheduledFuture == null) {
            return;
        }
        this.scheduledFuture.cancel(true);
        e.waitFor(this.executorService.submit(() -> {
            try {
                UUID localUuid = this.sessionId;
                if (localUuid != null) {
                    this.sessionClient.delete(localUuid);
                }
            }
            catch (IOException ex) {
                log.warn(null, ex);
            }
            this.sessionId = null;
        }));
    }

    private void ping() {
    }
}

