/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.data.materials;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.data.WaterType;
import net.runelite.client.plugins.hd.data.environments.Area;
import net.runelite.client.plugins.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.hd.data.materials.TileOverrideBuilder;
import net.runelite.client.plugins.hd.utils.HDUtils;

public enum Underlay {
    WINTER_GRASS(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_1).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_DIRT(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.DIRT).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_GRUNGE(p -> p.ids(new Integer[0]).groundMaterial(GroundMaterial.SNOW_2).hue(0).saturation(0).shiftLightness(40).blended(true)),
    WINTER_EDGEVILLE_PATH(p -> p.ids(new Integer[0]).blendedAsOpposite(true).hue(0).shiftLightness(8).saturation(0).groundMaterial(GroundMaterial.WINTER_JAGGED_STONE_TILE_LIGHT)),
    LUMBRIDGE_CASTLE_TILE(56, Area.LUMBRIDGE_CASTLE_BASEMENT, GroundMaterial.MARBLE_2_SEMIGLOSS, p -> p.blended(false)),
    VARROCK_JULIETS_HOUSE_UPSTAIRS(8, Area.VARROCK_JULIETS_HOUSE, GroundMaterial.NONE, p -> p.blended(false)),
    TOLNA_DUNGEON_ANGER_FLOOR(Area.TOLNA_DUNGEON_ANGER, GroundMaterial.DIRT, p -> p.ids(58, 58)),
    WARRIORS_GUILD_FLOOR_1(Area.WARRIORS_GUILD, GroundMaterial.VARROCK_PATHS, p -> p.ids(55, 56)),
    CATHERBY_BEACH_SAND(62, Area.CATHERBY, GroundMaterial.SAND),
    MAGE_TRAINING_ARENA_FLOOR_PATTERN(56, Area.MAGE_TRAINING_ARENA, GroundMaterial.TILES_2x2_2_GLOSS, p -> p.blended(false)),
    PVP_ARENA_PITFLOOR_SAND_REMOVAL(GroundMaterial.DIRT, p -> p.area(Area.PVP_ARENA).ids(66, 68)),
    SOPHANEM_TRAPDOOR(Area.SOPHANEM_TRAPDOOR, GroundMaterial.NONE, p -> {}),
    KHARID_SAND_1(Area.KHARID_DESERT_REGION, GroundMaterial.SAND, p -> p.saturation(3).hue(6).ids(61, 62, 67, 68, -127, 126, 49, 58, 63, 64, 50, 45)),
    NECROPOLIS_SAND(Area.NECROPOLIS, GroundMaterial.DIRT, p -> p.ids(124)),
    GAMES_ROOM_INNER_FLOOR(64, Area.GAMES_ROOM_INNER, GroundMaterial.CARPET, p -> p.blended(false)),
    GAMES_ROOM_FLOOR(64, Area.GAMES_ROOM, GroundMaterial.WOOD_PLANKS_1, p -> p.blended(false)),
    CRANDOR_SAND(-110, Area.CRANDOR, GroundMaterial.SAND, p -> p.saturation(3).hue(6)),
    GOD_WARS_DUNGEON_SNOW_1(Area.GOD_WARS_DUNGEON, GroundMaterial.SNOW_1, p -> p.ids(58, 59)),
    INFERNO_1(Area.THE_INFERNO, GroundMaterial.VARIED_DIRT, p -> p.ids(-118, 61, -115, -111, -110, 1, 61, 62, 72, 118, 122)),
    TZHAAR(72, Area.TZHAAR, GroundMaterial.VARIED_DIRT_SHINY, p -> p.shiftLightness(2)),
    VER_SINHAZA_WATER_FIX(p -> p.ids(54).area(Area.VER_SINHAZA_WATER_FIX).waterType(WaterType.WATER).blended(false)),
    SOUTH_OF_ZOO_FIX(61, Area.ARDOUGNE_SOUTH_OF_ZOO, GroundMaterial.OVERWORLD_GRASS_1),
    CENTER_SARADOMIN_SIDE_DIRT_1(98, Area.CASTLE_WARS_ARENA_SARADOMIN_SIDE, GroundMaterial.DIRT, p -> p.hue(7).saturation(4)),
    CENTER_SARADOMIN_SIDE_DIRT_2(56, Area.CASTLE_WARS_ARENA_SARADOMIN_SIDE, GroundMaterial.DIRT, p -> p.hue(7).saturation(4).shiftLightness(3)),
    YANILLE_AGILITY_DUNGEON_ENTRANCE_FIX(63, Area.YANILLE_AGILITY_DUNGEON_ENTRANCE, GroundMaterial.NONE, p -> p.blended(false)),
    ICEBERG_TEXTURE(p -> p.area(Area.ICEBERG).groundMaterial(GroundMaterial.SNOW_2).ids(59).shiftLightness(5)),
    ZANARIS_GRASS(Area.ZANARIS, GroundMaterial.GRASS_1, p -> p.ids(143, 144)),
    ZANARIS_DIRTS(Area.ZANARIS, GroundMaterial.VARIED_DIRT, p -> p.ids(66, 67)),
    COSMIC_ENTITYS_PLANE_ABYSS(Area.COSMIC_ENTITYS_PLANE, GroundMaterial.NONE, p -> p.lightness(0).blended(false).ids(2, 72)),
    ICE_QUEENS_DUNGEON_UNDERLAY(Area.ICE_QUEENS_DUNGEON, GroundMaterial.SNOW_1, p -> p.ids(58).lightness(100).hue(0).saturation(0)),
    TAVERLY_DUNGEON_DIRT(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.TAVERLEY_DUNGEON).ids(50, 63, 64, 66, 67)),
    TAVERLY_DUNGEON_BLACK_KNIGHTS_BASE(GroundMaterial.MARBLE_1_SEMIGLOSS, p -> p.area(Area.TAVERLEY_DUNGEON).ids(56, 57)),
    HEROES_GUILD_BASEMENT_CAVE(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.HEROES_GUILD_BASEMENT).ids(63)),
    HEROES_GUILD_BASEMENT_GRASS(GroundMaterial.GRASS_1, p -> p.area(Area.HEROES_GUILD_BASEMENT).ids(48, 49, 50)),
    MOTHERLODE_MINE(GroundMaterial.EARTHEN_CAVE_FLOOR, p -> p.area(Area.MOTHERLODE_MINE).ids(63, 64, 71)),
    GOBLIN_VILLAGE_TILES_BLEND_FIX(Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.WORN_TILES, p -> p.ids(56, 57).blended(true)),
    GOBLIN_VILLAGE_TILES(Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.WORN_TILES, p -> p.ids(56, 57).blended(false)),
    GOBLIN_VILLAGE_COOKS_PIT(118, Area.GOBLIN_VILLAGE_COOKS_CHAMBER, GroundMaterial.VARIED_DIRT_SHINY),
    PENGUIN_BASE_FLOOR(p -> p.area(Area.PENGUIN_BASE).groundMaterial(GroundMaterial.ICE_4).ids(59)),
    DEATHS_OFFICE_TILE(-110, Area.DEATHS_OFFICE, GroundMaterial.TILES_2x2_1_SEMIGLOSS),
    COX_SNOW_1(16, Area.COX_SNOW, GroundMaterial.SNOW_1),
    COX_SNOW_2(59, Area.COX_SNOW, GroundMaterial.SNOW_2),
    TOA_CRONDIS_ISLAND(Area.TOA_PATH_OF_CRONDIS_BOSS, GroundMaterial.SAND, p -> p.ids(109, 117)),
    TOA_CRONDIS_WATER_GREEN(p -> p.ids(133, 134).area(Area.TOA_CRONDIS_WATER).waterType(WaterType.POISON_WASTE).blended(false)),
    TOA_CRONDIS_WATER_BLUE(p -> p.area(Area.TOA_CRONDIS_WATER).waterType(WaterType.WATER).blended(false)),
    MAGE_ARENA_BANK_FLOOR(p -> p.ids(55, 56, 57).area(Area.MAGE_ARENA_BANK).groundMaterial(GroundMaterial.STONE_CAVE_FLOOR)),
    MAGE_ARENA_STATUE_ROOM_FLOOR(p -> p.ids(55, 56, 57).area(Area.MAGE_ARENA_GOD_STATUES).groundMaterial(GroundMaterial.STONE_CAVE_FLOOR)),
    MIND_ALTAR_TILE(55, Area.MIND_ALTAR, GroundMaterial.MARBLE_1_SEMIGLOSS, p -> p.blended(false)),
    TEMPLE_OF_THE_EYE(Area.TEMPLE_OF_THE_EYE, GroundMaterial.GRUNGE, p -> p.ids(87, 88, 89)),
    ARCEUUS_GROUND(Area.ARCEUUS, GroundMaterial.DIRT, p -> p.ids(2, 3, 17, 23, 24)),
    CANOE_CUTSCENE_GRASS(Area.CANOE_CUTSCENE, GroundMaterial.GRASS_SCROLLING, p -> p.ids(48, 50, 63)),
    OVERWORLD_GRASS(Area.OVERWORLD, GroundMaterial.OVERWORLD_GRASS_1, p -> p.ids(25, 33, 34, 40, 48, 49, 50, 51, 52, 53, 54, 62, 63, 67, 70, 71, 75, 93, 96, 97, 99, 100, 103, 114, 115, 126).replaceWithIf(WINTER_GRASS, plugin -> plugin.configWinterTheme)),
    OVERWORLD_DIRT(Area.OVERWORLD, GroundMaterial.DIRT, p -> p.ids(-111, -110, 19, 56, 57, 64, 65, 66, 80, 92, 94, 111, 118, 122, 139, 150).replaceWithIf(WINTER_DIRT, plugin -> plugin.configWinterTheme)),
    OVERWORLD_SAND(Area.OVERWORLD, GroundMaterial.SAND, p -> p.ids(-127, -118, 61, 68)),
    UNDERLAY_SNOW(GroundMaterial.SNOW_1, p -> p.ids(58, 59)),
    UNDERLAY_72(GroundMaterial.VARIED_DIRT, p -> p.ids(72, 73, 98, 112, 113).replaceWithIf(WINTER_DIRT, plugin -> plugin.configWinterTheme)),
    UNDERLAY_OVERWORLD_GRUNGE(GroundMaterial.GRUNGE, p -> p.ids(8, 10, 55, 60, 92).replaceWithIf(WINTER_GRUNGE, plugin -> plugin.configWinterTheme)),
    NONE(GroundMaterial.DIRT, p -> {});

    @Nullable
    public final Integer[] filterIds;
    public final Area area;
    public final GroundMaterial groundMaterial;
    public final WaterType waterType;
    public final boolean blended;
    public final boolean blendedAsOverlay;
    public final int hue;
    public final int shiftHue;
    public final int saturation;
    public final int shiftSaturation;
    public final int lightness;
    public final int shiftLightness;
    public final Underlay replacementUnderlay;
    public final Function<HdPlugin, Boolean> replacementCondition;
    private static final Underlay[] ANY_MATCH;
    private static final HashMap<Integer, Underlay[]> FILTERED_MAP;

    private Underlay(int id, Area area, GroundMaterial material) {
        this(p -> p.ids(id).groundMaterial(material).area(area));
    }

    private Underlay(int id, Area area, GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.ids(id).groundMaterial(material).area(area).apply(consumer));
    }

    private Underlay(GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.groundMaterial(material).apply(consumer));
    }

    private Underlay(Area area, GroundMaterial material, Consumer<TileOverrideBuilder<Underlay>> consumer) {
        this(p -> p.groundMaterial(material).area(area).apply(consumer));
    }

    private Underlay(Consumer<TileOverrideBuilder<Underlay>> consumer) {
        TileOverrideBuilder builder = new TileOverrideBuilder();
        consumer.accept(builder);
        this.filterIds = builder.ids;
        this.area = builder.area;
        this.groundMaterial = builder.groundMaterial;
        this.waterType = builder.waterType;
        this.blended = builder.blended;
        this.blendedAsOverlay = builder.blendedAsOpposite;
        this.hue = builder.hue;
        this.shiftHue = builder.shiftHue;
        this.saturation = builder.saturation;
        this.shiftSaturation = builder.shiftSaturation;
        this.lightness = builder.lightness;
        this.shiftLightness = builder.shiftLightness;
        this.replacementUnderlay = (Underlay)((Object)builder.replacement);
        this.replacementCondition = builder.replacementCondition;
    }

    public static Underlay getUnderlay(Scene scene, Tile tile, HdPlugin plugin) {
        short underlayId;
        Underlay[] underlays;
        LocalPoint localLocation = tile.getLocalLocation();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(scene, tile.getLocalLocation(), tile.getPlane());
        Underlay match = NONE;
        for (Underlay underlay : ANY_MATCH) {
            if (!underlay.area.containsPoint(worldPoint)) continue;
            match = underlay;
            break;
        }
        if ((underlays = FILTERED_MAP.get(underlayId = scene.getUnderlayIds()[tile.getRenderLevel()][localLocation.getSceneX()][localLocation.getSceneY()])) != null) {
            for (Underlay underlay : underlays) {
                if (underlay.ordinal() >= match.ordinal()) break;
                if (!underlay.area.containsPoint(worldPoint)) continue;
                match = underlay;
                break;
            }
        }
        return match.replacementCondition.apply(plugin) != false ? match.replacementUnderlay : match;
    }

    public int[] modifyColor(int[] colorHSL) {
        colorHSL[0] = this.hue >= 0 ? this.hue : colorHSL[0];
        colorHSL[0] = colorHSL[0] + this.shiftHue;
        colorHSL[0] = HDUtils.clamp(colorHSL[0], 0, 63);
        colorHSL[1] = this.saturation >= 0 ? this.saturation : colorHSL[1];
        colorHSL[1] = colorHSL[1] + this.shiftSaturation;
        colorHSL[1] = HDUtils.clamp(colorHSL[1], 0, 7);
        colorHSL[2] = this.lightness >= 0 ? this.lightness : colorHSL[2];
        colorHSL[2] = colorHSL[2] + this.shiftLightness;
        colorHSL[2] = HDUtils.clamp(colorHSL[2], 0, 127);
        return colorHSL;
    }

    static {
        FILTERED_MAP = new HashMap();
        ArrayList<Underlay> anyMatch = new ArrayList<Underlay>();
        ArrayListMultimap<Integer, Underlay> multiMap = ArrayListMultimap.create();
        for (Underlay underlay : Underlay.values()) {
            if (underlay.filterIds == null) {
                anyMatch.add(underlay);
                continue;
            }
            for (Integer id : underlay.filterIds) {
                multiMap.put(id, underlay);
            }
        }
        ANY_MATCH = anyMatch.toArray(new Underlay[0]);
        for (Map.Entry entry : multiMap.asMap().entrySet()) {
            FILTERED_MAP.put((Integer)entry.getKey(), ((Collection)entry.getValue()).toArray(new Underlay[0]));
        }
    }
}

