/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.playerindicators;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.plugins.playerindicators.PlayerNameLocation;

@ConfigGroup(value="playerindicators")
public interface PlayerIndicatorsConfig
extends Config {
    @ConfigSection(name="Highlight Options", description="Toggle highlighted players by type (self, friends, etc.) and choose their highlight colors", position=99)
    public static final String highlightSection = "section";

    @ConfigItem(position=0, keyName="drawOwnName", name="Highlight own player", description="Configures whether or not your own player should be highlighted", section="section")
    default public boolean highlightOwnPlayer() {
        return false;
    }

    @ConfigItem(position=1, keyName="ownNameColor", name="Own player", description="Color of your own player", section="section")
    default public Color getOwnPlayerColor() {
        return new Color(0, 184, 212);
    }

    @ConfigItem(position=2, keyName="drawFriendNames", name="Highlight friends", description="Configures whether or not friends should be highlighted", section="section")
    default public boolean highlightFriends() {
        return true;
    }

    @ConfigItem(position=3, keyName="friendNameColor", name="Friend", description="Color of friend names", section="section")
    default public Color getFriendColor() {
        return new Color(0, 200, 83);
    }

    @ConfigItem(position=10, keyName="drawNonClanMemberNames", name="Highlight others", description="Configures whether or not other players should be highlighted", section="section")
    default public boolean highlightOthers() {
        return false;
    }

    @ConfigItem(position=11, keyName="nonClanMemberColor", name="Others", description="Color of other players names", section="section")
    default public Color getOthersColor() {
        return Color.RED;
    }

    @ConfigItem(position=10, keyName="drawPlayerTiles", name="Draw tiles under players", description="Configures whether or not tiles under highlighted players should be drawn")
    default public boolean drawTiles() {
        return false;
    }

    @ConfigItem(position=11, keyName="playerNamePosition", name="Name position", description="Configures the position of drawn player names, or if they should be disabled")
    default public PlayerNameLocation playerNamePosition() {
        return PlayerNameLocation.ABOVE_HEAD;
    }

    @ConfigItem(position=12, keyName="drawMinimapNames", name="Draw names on minimap", description="Configures whether or not minimap names for players with rendered names should be drawn")
    default public boolean drawMinimapNames() {
        return false;
    }

    @ConfigItem(position=13, keyName="condensePlayerOptions", name="Condense player options", description="Move player options like Follow and Trade with to submenus")
    default public boolean condensePlayerOptions() {
        return false;
    }
}

