/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.Map;
import net.runelite.client.ui.PluginPanel;

public final class NavigationButton {
    static final Comparator<NavigationButton> COMPARATOR = Comparator.comparing(NavigationButton::getPriority).thenComparing(NavigationButton::getTooltip);
    private final BufferedImage icon;
    private final String tooltip;
    private final boolean selected;
    private final Runnable onClick;
    private final Runnable onSelect;
    private final PluginPanel panel;
    private final int priority;
    private final Map<String, Runnable> popup;

    private static String $default$tooltip() {
        return "";
    }

    NavigationButton(BufferedImage icon, String tooltip, boolean selected, Runnable onClick, Runnable onSelect, PluginPanel panel, int priority, Map<String, Runnable> popup) {
        this.icon = icon;
        this.tooltip = tooltip;
        this.selected = selected;
        this.onClick = onClick;
        this.onSelect = onSelect;
        this.panel = panel;
        this.priority = priority;
        this.popup = popup;
    }

    public static NavigationButtonBuilder builder() {
        return new NavigationButtonBuilder();
    }

    public BufferedImage getIcon() {
        return this.icon;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Runnable getOnClick() {
        return this.onClick;
    }

    public Runnable getOnSelect() {
        return this.onSelect;
    }

    public PluginPanel getPanel() {
        return this.panel;
    }

    public int getPriority() {
        return this.priority;
    }

    public Map<String, Runnable> getPopup() {
        return this.popup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NavigationButton)) {
            return false;
        }
        NavigationButton other = (NavigationButton)o;
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        BufferedImage this$icon = this.getIcon();
        BufferedImage other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$tooltip = this.getTooltip();
        String other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        Runnable this$onClick = this.getOnClick();
        Runnable other$onClick = other.getOnClick();
        if (this$onClick == null ? other$onClick != null : !this$onClick.equals(other$onClick)) {
            return false;
        }
        Runnable this$onSelect = this.getOnSelect();
        Runnable other$onSelect = other.getOnSelect();
        if (this$onSelect == null ? other$onSelect != null : !this$onSelect.equals(other$onSelect)) {
            return false;
        }
        PluginPanel this$panel = this.getPanel();
        PluginPanel other$panel = other.getPanel();
        if (this$panel == null ? other$panel != null : !this$panel.equals(other$panel)) {
            return false;
        }
        Map<String, Runnable> this$popup = this.getPopup();
        Map<String, Runnable> other$popup = other.getPopup();
        return !(this$popup == null ? other$popup != null : !((Object)this$popup).equals(other$popup));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isSelected() ? 79 : 97);
        result2 = result2 * 59 + this.getPriority();
        BufferedImage $icon = this.getIcon();
        result2 = result2 * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $tooltip = this.getTooltip();
        result2 = result2 * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        Runnable $onClick = this.getOnClick();
        result2 = result2 * 59 + ($onClick == null ? 43 : $onClick.hashCode());
        Runnable $onSelect = this.getOnSelect();
        result2 = result2 * 59 + ($onSelect == null ? 43 : $onSelect.hashCode());
        PluginPanel $panel = this.getPanel();
        result2 = result2 * 59 + ($panel == null ? 43 : $panel.hashCode());
        Map<String, Runnable> $popup = this.getPopup();
        result2 = result2 * 59 + ($popup == null ? 43 : ((Object)$popup).hashCode());
        return result2;
    }

    public String toString() {
        return "NavigationButton(icon=" + this.getIcon() + ", tooltip=" + this.getTooltip() + ", selected=" + this.isSelected() + ", onClick=" + this.getOnClick() + ", onSelect=" + this.getOnSelect() + ", panel=" + this.getPanel() + ", priority=" + this.getPriority() + ", popup=" + this.getPopup() + ")";
    }

    public static class NavigationButtonBuilder {
        private BufferedImage icon;
        private boolean tooltip$set;
        private String tooltip$value;
        private boolean selected;
        private Runnable onClick;
        private Runnable onSelect;
        private PluginPanel panel;
        private int priority;
        private Map<String, Runnable> popup;

        NavigationButtonBuilder() {
        }

        public NavigationButtonBuilder icon(BufferedImage icon) {
            this.icon = icon;
            return this;
        }

        public NavigationButtonBuilder tooltip(String tooltip) {
            this.tooltip$value = tooltip;
            this.tooltip$set = true;
            return this;
        }

        public NavigationButtonBuilder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        public NavigationButtonBuilder onClick(Runnable onClick) {
            this.onClick = onClick;
            return this;
        }

        public NavigationButtonBuilder onSelect(Runnable onSelect) {
            this.onSelect = onSelect;
            return this;
        }

        public NavigationButtonBuilder panel(PluginPanel panel) {
            this.panel = panel;
            return this;
        }

        public NavigationButtonBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public NavigationButtonBuilder popup(Map<String, Runnable> popup) {
            this.popup = popup;
            return this;
        }

        public NavigationButton build() {
            String tooltip$value = this.tooltip$value;
            if (!this.tooltip$set) {
                tooltip$value = NavigationButton.$default$tooltip();
            }
            return new NavigationButton(this.icon, tooltip$value, this.selected, this.onClick, this.onSelect, this.panel, this.priority, this.popup);
        }

        public String toString() {
            return "NavigationButton.NavigationButtonBuilder(icon=" + this.icon + ", tooltip$value=" + this.tooltip$value + ", selected=" + this.selected + ", onClick=" + this.onClick + ", onSelect=" + this.onSelect + ", panel=" + this.panel + ", priority=" + this.priority + ", popup=" + this.popup + ")";
        }
    }
}

