/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ShmTest {
    protected static final int NUM = 1000000;
    protected static final int SIZE = 1000;
    protected static final int PRINT = 100000;
    protected static final int MAX_BUSY_SPIN = 1000;

    protected static void start(boolean server) throws Exception {
        RandomAccessFile file = new RandomAccessFile("/tmp/shm", "rwd");
        FileChannel channel = file.getChannel();
        MappedByteBuffer shared_buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 1010L);
        file.close();
        int count2 = 0;
        int busy_spin = 0;
        if (server) {
            while (count2 < 1000000) {
                byte input = shared_buffer.get(0);
                if (input == 0) {
                    byte[] buf = new byte[1000];
                    shared_buffer.put(buf, 0, buf.length);
                    shared_buffer.rewind();
                    shared_buffer.put((byte)1).rewind();
                    if (++count2 % 100000 != 0) continue;
                    System.out.println("wrote " + count2);
                    continue;
                }
                busy_spin = 0;
                while ((input = shared_buffer.get(0)) != 0) {
                    if (busy_spin++ < 1000) continue;
                    Thread.yield();
                }
            }
        } else {
            long start = System.nanoTime();
            while (count2 < 1000000) {
                byte input = shared_buffer.get(0);
                if (input == 1) {
                    byte[] buf = new byte[1000];
                    shared_buffer.get(buf, 0, buf.length);
                    shared_buffer.rewind();
                    shared_buffer.put((byte)0).rewind();
                    if (++count2 % 100000 != 0) continue;
                    System.out.println("read " + count2);
                    continue;
                }
                busy_spin = 0;
                while ((input = shared_buffer.get(0)) != 1) {
                    if (busy_spin++ < 1000) continue;
                    Thread.yield();
                }
            }
            long time = System.nanoTime() - start;
            long reads_sec = (long)(1000000.0 / ((double)time / 1000.0 / 1000.0 / 1000.0));
            double ns_per_msg = time / 1000000L;
            double ms_per_msg = (double)time / 1000000.0 / 1000000.0;
            double throughput = 1000.0 / ((double)time / 1.0E9);
            System.out.println((double)time / 1000000.0 + " ms, " + reads_sec + " reads/sec, " + ns_per_msg + " ns/msg, " + ms_per_msg + " ms/msg, " + throughput + " MB/sec");
        }
    }

    public static void main(String[] args2) throws Exception {
        ShmTest.start(args2.length > 0);
    }
}

