/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceWidgetManager;
import org.pushingpixels.substance.internal.utils.TrackableThread;
import org.pushingpixels.substance.internal.utils.filters.RenderingUtils;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceTitlePane
extends JComponent {
    private PropertyChangeListener propertyChangeListener;
    protected JMenuBar menuBar;
    private boolean isControlOnlyMode;
    private int preferredHeight;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    protected JButton toggleButton;
    protected JButton minimizeButton;
    protected JButton closeButton;
    private WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    private int state;
    private SubstanceRootPaneUI rootPaneUI;
    private static String heapStatusLogfileName;
    protected HeapStatusPanel heapStatusPanel;
    protected JCheckBoxMenuItem heapStatusMenuItem;
    protected PropertyChangeListener propertyListener;
    protected Image appIcon;

    public SubstanceTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType(this, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        this.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceCoreUtilities.getSkin(this).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        HeapStatusThread.unregisterPanel(this.heapStatusPanel);
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
            SubstanceCoreUtilities.uninstallMenu(this.menuBar.getMenu(0));
        }
        if (this.heapStatusPanel != null) {
            for (MouseListener listener : this.heapStatusPanel.getMouseListeners()) {
                this.heapStatusPanel.removeMouseListener(listener);
            }
            HeapStatusThread.unregisterPanel(this.heapStatusPanel);
            this.remove(this.heapStatusPanel);
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyListener = evt -> {
            if ("substancelaf.internal.contentsModified".equals(evt.getPropertyName())) {
                this.syncCloseButtonTooltip();
            }
            if ("componentOrientation".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.menuBar != null) {
                        this.menuBar.applyComponentOrientation((ComponentOrientation)evt.getNewValue());
                    }
                });
            }
        };
        this.rootPane.addPropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().addPropertyChangeListener(this.propertyListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.rootPane.removePropertyChangeListener(this.propertyListener);
        if (this.getFrame() != null) {
            this.getFrame().removePropertyChangeListener(this.propertyListener);
        }
        this.propertyListener = null;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            if (this.getComponentCount() == 0) {
                this.installSubcomponents();
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
        this.updateAppIcon();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            if (this.menuBar != null) {
                this.add(this.menuBar);
            }
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.heapStatusPanel = new HeapStatusPanel();
            SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.heapStatusPanel, SubstanceTitlePaneUtilities.ExtraComponentKind.TRAILING);
            this.add(this.heapStatusPanel);
            boolean isHeapStatusPanelShowing = SubstanceWidgetManager.getInstance().isAllowed(this.rootPane, SubstanceSlices.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS);
            this.heapStatusPanel.setVisible(isHeapStatusPanelShowing);
            this.heapStatusPanel.setPreferredSize(new Dimension(80, this.getPreferredSize().height));
            this.heapStatusPanel.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("Tooltip.heapStatusPanel"));
            this.heapStatusPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.gc();
                }
            });
            HeapStatusThread.registerPanel(this.heapStatusPanel);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        SubstanceSlices.TitleIconHorizontalGravity iconGravity = SubstanceTitlePaneUtilities.getTitlePaneIconGravity();
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(this.menuBar, iconGravity == SubstanceSlices.TitleIconHorizontalGravity.NEXT_TO_TITLE ? SubstanceTitlePaneUtilities.ExtraComponentKind.WITH_TITLE : SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING);
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.setOpaque(false);
        menu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        if (SubstanceCoreUtilities.toShowExtraWidgets(this.rootPane)) {
            menu.addSeparator();
            JMenu skinMenu = new JMenu(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.skins"));
            Map<String, SkinInfo> allSkins = SubstanceCortex.GlobalScope.getAllSkins();
            for (Map.Entry<String, SkinInfo> skinEntry : allSkins.entrySet()) {
                String skinClassName = skinEntry.getValue().getClassName();
                JMenuItem jmiSkin = new JMenuItem(skinEntry.getKey());
                jmiSkin.addActionListener(e -> SwingUtilities.invokeLater(() -> SubstanceCortex.GlobalScope.setSkin(skinClassName)));
                skinMenu.add(jmiSkin);
            }
            menu.add(skinMenu);
        }
        menu.addSeparator();
        menu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        SubstanceTitleButton button = new SubstanceTitleButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent(button, SubstanceTitlePaneUtilities.getTitlePaneControlButtonKind(this.rootPane));
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setBorder(null);
        TransitionAwareIcon closeIcon = new TransitionAwareIcon(this.closeButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, scheme, SubstanceCoreUtilities.getSkin(this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)), "substance.titlePane.closeIcon");
        this.closeButton.setIcon(closeIcon);
        this.closeButton.setFocusable(false);
        SubstanceCortex.ComponentOrParentScope.setFlatBackground(this.closeButton, true);
        this.closeButton.putClientProperty("substancelaf.internal.isTitleCloseButton", Boolean.TRUE);
        if (this.getWindowDecorationStyle() == 1) {
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.setBorder(null);
            TransitionAwareIcon minIcon = new TransitionAwareIcon(this.minimizeButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, scheme, SubstanceCoreUtilities.getSkin(this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)), "substance.titlePane.minIcon");
            this.minimizeButton.setIcon(minIcon);
            this.minimizeButton.setFocusable(false);
            SubstanceCortex.ComponentOrParentScope.setFlatBackground(this.minimizeButton, true);
            this.minimizeButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.setText(null);
            this.toggleButton.setBorder(null);
            TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, scheme, SubstanceCoreUtilities.getSkin(this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)), "substance.titlePane.maxIcon");
            this.toggleButton.setIcon(maxIcon);
            this.toggleButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
            this.toggleButton.setFocusable(false);
            SubstanceCortex.ComponentOrParentScope.setFlatBackground(this.toggleButton, true);
        }
        this.syncCloseButtonTooltip();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        if (this.window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        TransitionAwareIcon restoreIcon = new TransitionAwareIcon(this.toggleButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, scheme, SubstanceCoreUtilities.getSkin(rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)), "substance.titlePane.restoreIcon");
                        this.updateToggleButton(this.restoreAction, restoreIcon);
                        this.toggleButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"));
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        TransitionAwareIcon maxIcon = new TransitionAwareIcon(this.toggleButton, scheme -> SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, scheme, SubstanceCoreUtilities.getSkin(rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)), "substance.titlePane.maxIcon");
                        this.updateToggleButton(this.maximizeAction, maxIcon);
                        this.toggleButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"));
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    private String getTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return null;
    }

    private String getDisplayTitle() {
        String theTitle = this.getTitle();
        if (theTitle == null) {
            return null;
        }
        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
        Rectangle titleTextRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.window != null ? this.window : this.getRootPane());
        FontMetrics fm = this.rootPane.getFontMetrics(font);
        int titleWidth = titleTextRect.width - 20;
        String clippedTitle = SubstanceCoreUtilities.clipString(fm, titleWidth, theTitle);
        return clippedTitle;
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        if (this.isControlOnlyMode) {
            return;
        }
        JRootPane rootPane = this.getRootPane();
        boolean leftToRight = this.window == null ? rootPane.getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(rootPane);
        if (skin == null) {
            SubstanceCoreUtilities.traceSubstanceApiUsage(this, "Substance delegate used when Substance is not the current LAF");
        }
        SubstanceColorScheme scheme = skin.getEnabledColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        String theTitle = this.getTitle();
        String displayTitle = this.getDisplayTitle();
        Graphics2D graphics = (Graphics2D)g2.create();
        BackgroundPaintingUtils.update(graphics, this, false);
        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
        graphics.setFont(font);
        if (displayTitle != null) {
            Rectangle titleTextRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(this, this.window != null ? this.window : this.getRootPane());
            FontMetrics fm = rootPane.getFontMetrics(font);
            int displayTitleWidth = fm.stringWidth(displayTitle);
            if (theTitle.equals(displayTitle)) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(theTitle);
            }
            int xOffset = 0;
            SubstanceSlices.HorizontalGravity titleTextGravity = SubstanceTitlePaneUtilities.getTitlePaneTextGravity();
            switch (titleTextGravity) {
                case LEADING: {
                    xOffset = leftToRight ? titleTextRect.x : titleTextRect.x + titleTextRect.width - displayTitleWidth;
                    break;
                }
                case TRAILING: {
                    xOffset = leftToRight ? titleTextRect.x + titleTextRect.width - displayTitleWidth : titleTextRect.x;
                    break;
                }
                default: {
                    xOffset = titleTextRect.x + (titleTextRect.width - displayTitleWidth) / 2;
                }
            }
            int yOffset = titleTextRect.y + (int)((titleTextRect.getHeight() - (double)fm.getHeight()) / 2.0) + fm.getAscent();
            SubstanceColorScheme fillScheme = skin.getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            Color echoColor = !fillScheme.isDark() ? fillScheme.getUltraDarkColor() : fillScheme.getUltraLightColor();
            SubstanceTextUtilities.paintTextWithDropShadow(this, graphics, SubstanceColorUtilities.getForegroundColor(scheme), echoColor, displayTitle, width, height, xOffset, yOffset);
        }
        GhostPaintingUtils.paintGhostImages(this, graphics);
        graphics.dispose();
    }

    public static void setHeapStatusLogfileName(String heapStatusLogfileName) {
        SubstanceTitlePane.heapStatusLogfileName = heapStatusLogfileName;
    }

    protected void syncCloseButtonTooltip() {
        if (SubstanceCoreUtilities.isRootPaneModified(this.getRootPane())) {
            this.closeButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close") + " [" + SubstanceCortex.GlobalScope.getLabelBundle().getString("Tooltip.contentsNotSaved") + "]");
        } else {
            this.closeButton.setToolTipText(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close"));
        }
        this.closeButton.repaint();
    }

    private void updateAppIcon() {
        if (this.window == null) {
            this.appIcon = null;
            return;
        }
        List<Image> iconImages = this.window.getIconImages();
        if (iconImages.size() == 0) {
            this.appIcon = null;
        } else {
            int prefSize = this.getControlButtonSize();
            this.appIcon = SubstanceCoreUtilities.getScaledIconImage(iconImages, prefSize, prefSize);
        }
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    public int getControlButtonSize() {
        if (this.closeButton != null && this.closeButton.getIcon() != null) {
            return this.closeButton.getIcon().getIconHeight();
        }
        return SubstanceSizeUtils.getTitlePaneIconSize();
    }

    private int getControlButtonsSmallGap() {
        return 3;
    }

    private int getControlButtonsLargeGap() {
        return 10;
    }

    public void setControlOnlyMode() {
        this.isControlOnlyMode = true;
        this.setOpaque(false);
        this.revalidate();
        this.repaint();
    }

    public void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
        this.revalidate();
        this.repaint();
    }

    public JButton createControlButton() {
        JButton result2 = this.createTitleButton();
        int prefSize = this.getControlButtonSize();
        result2.setPreferredSize(new Dimension(prefSize, prefSize));
        SubstanceCortex.ComponentOrParentScope.setFlatBackground(result2, true);
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType(result2, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
        return result2;
    }

    private int getPaneHeight() {
        FontMetrics fm = this.rootPane.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        fontHeight += 7;
        int iconHeight = 0;
        if (this.getWindowDecorationStyle() == 1) {
            iconHeight = SubstanceSizeUtils.getTitlePaneIconSize();
        }
        int finalHeight = Math.max(fontHeight, iconHeight);
        finalHeight = Math.max(finalHeight, this.preferredHeight);
        return finalHeight;
    }

    public Insets getControlInsets() {
        int y;
        boolean controlButtonsOnRight = SubstanceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(this.getRootPane());
        int buttonSize = this.getControlButtonSize();
        int controlInsets = this.getControlButtonsSmallGap();
        controlInsets += buttonSize;
        if (this.getWindowDecorationStyle() == 1) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && this.toggleButton.getParent() != null) {
                controlInsets += this.getControlButtonsLargeGap();
                controlInsets += buttonSize;
            }
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null) {
                controlInsets += this.getControlButtonsSmallGap();
                controlInsets += buttonSize;
            }
            if (this.heapStatusPanel != null && this.heapStatusPanel.isVisible()) {
                controlInsets += this.getControlButtonsLargeGap();
                controlInsets += this.heapStatusPanel.getPreferredWidth();
            }
        }
        int height = this.getPaneHeight();
        SubstanceSlices.VerticalGravity buttonGroupVerticalGravity = SubstanceTitlePaneUtilities.getTitleControlButtonGroupVerticalGravity(this.rootPane);
        switch (buttonGroupVerticalGravity) {
            case TOP: {
                y = 0;
                break;
            }
            case BOTTOM: {
                y = height - buttonSize;
                break;
            }
            default: {
                y = (height - buttonSize) / 2;
            }
        }
        int leftInset = controlButtonsOnRight ? 0 : controlInsets;
        int rightInset = controlButtonsOnRight ? controlInsets : 0;
        int topInset = y;
        int bottomInset = height - y - buttonSize;
        return new Insets(topInset, leftInset, bottomInset, rightInset);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = SubstanceTitlePane.this.getFrame();
                if (frame != null) {
                    SubstanceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    SubstanceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                SubstanceTitlePane.this.setToolTipText((String)pce.getNewValue());
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            } else if ("iconImage" == name) {
                SubstanceTitlePane.this.updateAppIcon();
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = SubstanceTitlePane.this.getPaneHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            int y;
            JRootPane rootPane = SubstanceTitlePane.this.getRootPane();
            boolean leftToRight = rootPane.getComponentOrientation().isLeftToRight();
            boolean controlButtonsOnRight = SubstanceTitlePaneUtilities.areTitlePaneControlButtonsOnRight(rootPane);
            int w = SubstanceTitlePane.this.getWidth();
            int buttonSize = SubstanceTitlePane.this.getControlButtonSize();
            SubstanceSlices.VerticalGravity buttonGroupVerticalGravity = SubstanceTitlePaneUtilities.getTitleControlButtonGroupVerticalGravity(rootPane);
            int height = SubstanceTitlePane.this.getHeight();
            switch (buttonGroupVerticalGravity) {
                case TOP: {
                    y = 0;
                    break;
                }
                case BOTTOM: {
                    y = height - buttonSize;
                    break;
                }
                default: {
                    y = (height - buttonSize) / 2;
                }
            }
            int x = leftToRight ? w : 0;
            SubstanceSlices.TitleIconHorizontalGravity iconHorizontalGravity = SubstanceTitlePane.this.isControlOnlyMode ? SubstanceSlices.TitleIconHorizontalGravity.NONE : SubstanceTitlePaneUtilities.getTitlePaneIconGravity();
            SubstanceSlices.HorizontalGravity titleTextHorizontalGravity = SubstanceTitlePaneUtilities.getTitlePaneTextGravity();
            if (SubstanceTitlePane.this.menuBar != null) {
                int menuBarLeft;
                spacing = 5;
                block4 : switch (iconHorizontalGravity) {
                    case OPPOSITE_CONTROL_BUTTONS: {
                        menuBarLeft = controlButtonsOnRight ? spacing : w - buttonSize - spacing;
                        break;
                    }
                    case NEXT_TO_TITLE: {
                        Rectangle titleRect = SubstanceTitlePaneUtilities.getTitlePaneTextRectangle(SubstanceTitlePane.this, SubstanceTitlePane.this.window != null ? SubstanceTitlePane.this.window : SubstanceTitlePane.this.getRootPane());
                        String displayTitle = SubstanceTitlePane.this.getDisplayTitle();
                        FontUIResource font = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet("Substance", null).getWindowTitleFont();
                        int displayTitleWidth = rootPane.getFontMetrics(font).stringWidth(displayTitle);
                        switch (titleTextHorizontalGravity) {
                            case LEADING: {
                                menuBarLeft = leftToRight ? titleRect.x - buttonSize - spacing : titleRect.x + titleRect.width + spacing;
                                break block4;
                            }
                            case TRAILING: {
                                menuBarLeft = leftToRight ? titleRect.x + titleRect.width - displayTitleWidth - buttonSize - spacing : titleRect.x + titleRect.width + spacing;
                                break block4;
                            }
                        }
                        int displayTitleLeft = titleRect.x + (titleRect.width - displayTitleWidth) / 2;
                        menuBarLeft = leftToRight ? displayTitleLeft - buttonSize - spacing : displayTitleLeft + displayTitleWidth + spacing;
                        break;
                    }
                    default: {
                        menuBarLeft = -1;
                    }
                }
                if (menuBarLeft >= 0) {
                    SubstanceTitlePane.this.menuBar.setVisible(true);
                    SubstanceTitlePane.this.menuBar.setBounds(menuBarLeft, y, buttonSize, buttonSize);
                } else {
                    SubstanceTitlePane.this.menuBar.setVisible(false);
                }
            }
            x = controlButtonsOnRight ? w : 0;
            spacing = SubstanceTitlePane.this.getControlButtonsSmallGap();
            x += controlButtonsOnRight ? -spacing - buttonSize : spacing;
            if (SubstanceTitlePane.this.closeButton != null) {
                SubstanceTitlePane.this.closeButton.setBounds(x, y, buttonSize, buttonSize);
            }
            if (!controlButtonsOnRight) {
                x += buttonSize;
            }
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && SubstanceTitlePane.this.toggleButton.getParent() != null) {
                    spacing = SubstanceTitlePane.this.getControlButtonsLargeGap();
                    SubstanceTitlePane.this.toggleButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonSize : spacing, y, buttonSize, buttonSize);
                    if (!controlButtonsOnRight) {
                        x += buttonSize;
                    }
                }
                if (SubstanceTitlePane.this.minimizeButton != null && SubstanceTitlePane.this.minimizeButton.getParent() != null) {
                    spacing = SubstanceTitlePane.this.getControlButtonsSmallGap();
                    SubstanceTitlePane.this.minimizeButton.setBounds(x += controlButtonsOnRight ? -spacing - buttonSize : spacing, y, buttonSize, buttonSize);
                    if (!controlButtonsOnRight) {
                        x += buttonSize;
                    }
                }
                if (SubstanceTitlePane.this.heapStatusPanel != null && SubstanceTitlePane.this.heapStatusPanel.isVisible()) {
                    spacing = SubstanceTitlePane.this.getControlButtonsLargeGap();
                    SubstanceTitlePane.this.heapStatusPanel.setBounds(x += controlButtonsOnRight ? -spacing - SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth() : spacing, 1, SubstanceTitlePane.this.heapStatusPanel.getPreferredWidth(), SubstanceTitlePane.this.getHeight() - 3);
                }
            }
        }
    }

    public class SubstanceMenuBar
    extends JMenuBar {
        @Override
        public void paint(Graphics g2) {
            if (SubstanceTitlePane.this.appIcon != null) {
                float scaleFactor = SubstanceCoreUtilities.isHiDpiAwareImage(SubstanceTitlePane.this.appIcon) ? (float)UIUtil.getScaleFactor() : 1.0f;
                g2.drawImage(SubstanceTitlePane.this.appIcon, 0, 0, (int)((float)SubstanceTitlePane.this.appIcon.getWidth(null) / scaleFactor), (int)((float)SubstanceTitlePane.this.appIcon.getHeight(null) / scaleFactor), null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g2, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.maximize"), SubstanceImageCreator.getMaximizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                if (frame instanceof JFrame) {
                    SubstanceRootPaneUI rpUI = (SubstanceRootPaneUI)((JFrame)frame).getRootPane().getUI();
                    rpUI.setMaximized();
                }
                frame.setExtendedState(SubstanceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.restore"), SubstanceImageCreator.getRestoreIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((SubstanceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.iconify"), SubstanceImageCreator.getMinimizeIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(SubstanceCortex.GlobalScope.getLabelBundle().getString("SystemMenu.close"), SubstanceImageCreator.getCloseIcon(SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getActiveColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE), SubstanceCoreUtilities.getSkin(SubstanceTitlePane.this.rootPane).getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SubstanceTitlePane.this.window != null) {
                SubstanceTitlePane.this.window.dispatchEvent(new WindowEvent(SubstanceTitlePane.this.window, 201));
            }
        }
    }

    public static class HeapStatusThread
    extends TrackableThread {
        private int heapSizeKB;
        private int takenHeapSizeKB;
        private static Set<WeakReference<HeapStatusPanel>> panels = new HashSet<WeakReference<HeapStatusPanel>>();
        private static HeapStatusThread instance;
        private SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
        private boolean isStopRequested = false;

        private HeapStatusThread() {
            this.setName("Substance heap status");
        }

        public static synchronized HeapStatusThread getInstance() {
            if (instance == null) {
                instance = new HeapStatusThread();
                instance.start();
            }
            return instance;
        }

        public static synchronized void registerPanel(HeapStatusPanel panel) {
            panels.add(new WeakReference<HeapStatusPanel>(panel));
        }

        public static synchronized void unregisterPanel(HeapStatusPanel panel) {
            Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
            while (it.hasNext()) {
                WeakReference<HeapStatusPanel> ref = it.next();
                HeapStatusPanel currPanel = (HeapStatusPanel)ref.get();
                if (panel != currPanel) continue;
                it.remove();
                return;
            }
        }

        private synchronized void updateHeapCounts() {
            long heapSize = Runtime.getRuntime().totalMemory();
            long heapFreeSize = Runtime.getRuntime().freeMemory();
            this.heapSizeKB = (int)(heapSize / 1024L);
            this.takenHeapSizeKB = (int)((heapSize - heapFreeSize) / 1024L);
        }

        @Override
        public void run() {
            while (!this.isStopRequested) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!SubstanceWidgetManager.getInstance().isAllowedAnywhere(SubstanceSlices.SubstanceWidgetType.TITLE_PANE_HEAP_STATUS)) continue;
                this.updateHeapCounts();
                Iterator<WeakReference<HeapStatusPanel>> it = panels.iterator();
                while (it.hasNext()) {
                    WeakReference<HeapStatusPanel> refPanel = it.next();
                    HeapStatusPanel panel = (HeapStatusPanel)refPanel.get();
                    if (panel == null) {
                        it.remove();
                        continue;
                    }
                    panel.updateStatus(this.heapSizeKB, this.takenHeapSizeKB);
                }
                if (heapStatusLogfileName == null) continue;
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(heapStatusLogfileName, true));
                    Throwable throwable = null;
                    try {
                        pw.println(this.format.format(new Date()) + " " + this.takenHeapSizeKB + "KB / " + this.heapSizeKB + "KB");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pw == null) continue;
                        if (throwable != null) {
                            try {
                                pw.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        pw.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        protected void requestStop() {
            this.isStopRequested = true;
            instance = null;
        }
    }

    public static class HeapStatusPanel
    extends JPanel {
        private int currHeapSizeKB;
        private int currTakenHeapSizeKB;
        private LinkedList<Double> graphValues = new LinkedList();

        public HeapStatusPanel() {
            HeapStatusThread.getInstance();
        }

        public synchronized void updateStatus(int currHeapSizeKB, int currTakenHeapSizeKB) {
            this.currHeapSizeKB = currHeapSizeKB;
            this.currTakenHeapSizeKB = currTakenHeapSizeKB;
            double newGraphValue = (double)currTakenHeapSizeKB / (double)currHeapSizeKB;
            this.graphValues.addLast(newGraphValue);
            this.repaint();
        }

        @Override
        public synchronized void paint(Graphics g2) {
            Graphics2D graphics = (Graphics2D)g2.create();
            SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin(this).getActiveColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            graphics.setColor(scheme.getDarkColor());
            int w = this.getWidth();
            int h2 = this.getHeight();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
            graphics.setStroke(new BasicStroke(borderThickness, 0, 1));
            graphics.draw(new Rectangle2D.Float(borderThickness / 2.0f, borderThickness / 2.0f, (float)w - borderThickness, (float)h2 - borderThickness));
            graphics.setColor(scheme.getExtraLightColor());
            graphics.draw(new Rectangle2D.Float(borderThickness, borderThickness, (float)w - 2.0f * borderThickness, (float)h2 - 2.0f * borderThickness));
            graphics.setStroke(new BasicStroke(1.0f));
            while (this.graphValues.size() > w - 2) {
                this.graphValues.removeFirst();
            }
            int xOff = w - this.graphValues.size() - 1;
            graphics.setColor(scheme.getMidColor());
            int count2 = 0;
            Iterator iterator2 = this.graphValues.iterator();
            while (iterator2.hasNext()) {
                double value = (Double)iterator2.next();
                int valueH = (int)(value * (double)(h2 - 2));
                graphics.drawLine(xOff + count2, h2 - 1 - valueH, xOff + count2, h2 - 2);
                ++count2;
            }
            graphics.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fm = graphics.getFontMetrics();
            StringBuffer longFormat = new StringBuffer();
            Formatter longFormatter = new Formatter(longFormat);
            longFormatter.format("%.1fMB / %.1fMB", Float.valueOf((float)this.currTakenHeapSizeKB / 1024.0f), Float.valueOf((float)this.currHeapSizeKB / 1024.0f));
            longFormatter.close();
            int strW = fm.stringWidth(longFormat.toString());
            int strH = fm.getAscent() + fm.getDescent();
            graphics.setColor(scheme.getForegroundColor());
            RenderingUtils.installDesktopHints(graphics, this);
            if (strW < w - 5) {
                graphics.drawString(longFormat.toString(), (w - strW) / 2, (h2 + strH) / 2 - 2);
            } else {
                String shortFormat = this.currTakenHeapSizeKB / 1024 + "MB / " + this.currHeapSizeKB / 1024 + "MB";
                strW = fm.stringWidth(shortFormat);
                graphics.drawString(shortFormat, (w - strW) / 2, (h2 + strH) / 2 - 2);
            }
            graphics.dispose();
        }

        public int getPreferredWidth() {
            BufferedImage dummy = new BufferedImage(1, 1, 2);
            Graphics2D g2d = dummy.createGraphics();
            RenderingUtils.installDesktopHints(g2d, this);
            g2d.setFont(UIManager.getFont("Panel.font"));
            FontMetrics fm = g2d.getFontMetrics();
            int result2 = fm.stringWidth("100.9MB / 200.9MB");
            g2d.dispose();
            return result2;
        }
    }
}

