/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Frame;
import com.client.Model;
import com.client.Renderable;
import com.client.RuneLiteObjectImpl;
import com.client.definitions.GraphicsDefinition;
import com.client.definitions.SeqDefinition;
import net.runelite.api.Animation;
import net.runelite.api.coords.LocalPoint;
import net.runelite.rs.api.RSGraphicsObject;
import net.runelite.rs.api.RSSequenceDefinition;
import org.jetbrains.annotations.Nullable;

class GraphicObject
extends Renderable
implements RSGraphicsObject {
    private int gfxId;
    protected SeqDefinition sequenceDefinition;
    public int gfxHeightLevel;
    public int x;
    public int y;
    public int z;
    public final int gfxDisplayCycle;
    public boolean isFinished;
    private GraphicsDefinition gfxToDisplay;
    private int frame;
    private int cycle;

    public GraphicObject(int plane, int j, int l, int definitionId, int height, int k1, int xPos) {
        this.gfxId = definitionId;
        this.gfxToDisplay = GraphicsDefinition.cache[definitionId];
        this.sequenceDefinition = this.getDisplayedAnimation();
        this.gfxHeightLevel = plane;
        this.x = xPos;
        this.y = k1;
        this.z = height;
        this.gfxDisplayCycle = j + l;
        this.isFinished = false;
    }

    protected Model getDisplayedModel() {
        return this.gfxToDisplay.getModel();
    }

    protected SeqDefinition getDisplayedAnimation() {
        return this.gfxToDisplay.animationSequence;
    }

    @Override
    public Model getRotatedModel() {
        Model model = this.getDisplayedModel();
        if (model == null) {
            return null;
        }
        SeqDefinition animationSequence = this.getDisplayedAnimation();
        if (animationSequence == null || animationSequence.isEmpty()) {
            return null;
        }
        int frame = this.frame < animationSequence.frameIDs.length ? animationSequence.frameIDs[this.frame] : -1;
        Model model_1 = new Model(true, Frame.noAnimationInProgress(frame), false, model);
        if (!this.isFinished) {
            model_1.generateBones();
            model_1.interpolate(frame);
            model_1.groupedTriangleLabels = null;
            model_1.groupedVertexLabels = null;
        }
        if (this.gfxToDisplay.resizeXY != 128 || this.gfxToDisplay.resizeZ != 128) {
            model_1.scale(this.gfxToDisplay.resizeXY, this.gfxToDisplay.resizeXY, this.gfxToDisplay.resizeZ);
        }
        if (this.gfxToDisplay.rotation != 0) {
            if (this.gfxToDisplay.rotation == 90) {
                model_1.rotate90Degrees();
            }
            if (this.gfxToDisplay.rotation == 180) {
                model_1.rotate90Degrees();
                model_1.rotate90Degrees();
            }
            if (this.gfxToDisplay.rotation == 270) {
                model_1.rotate90Degrees();
                model_1.rotate90Degrees();
                model_1.rotate90Degrees();
            }
        }
        model_1.light(64 + this.gfxToDisplay.modelBrightness, 850 + this.gfxToDisplay.modelShadow, -30, -50, -30, true);
        return model_1;
    }

    public void update(int animationCycle) {
        SeqDefinition seqDefinition = this.getDisplayedAnimation();
        if (this.gfxToDisplay == null || seqDefinition == null || seqDefinition.isEmpty()) {
            if (!(this instanceof RuneLiteObjectImpl)) {
                this.isFinished = true;
            }
            return;
        }
        this.cycle += animationCycle;
        while (this.cycle > seqDefinition.getDuration(this.frame)) {
            this.cycle -= seqDefinition.getDuration(this.frame) + 1;
            ++this.frame;
            if (this.frame < seqDefinition.frameCount) continue;
            this.frame = 0;
            if (this.isLooping()) {
                this.setFrame(0);
                this.setFrameCycle(0);
                continue;
            }
            this.isFinished = true;
        }
    }

    protected boolean isLooping() {
        return false;
    }

    @Override
    public LocalPoint getLocation() {
        return new LocalPoint(this.x, this.y);
    }

    @Override
    @Nullable
    public Animation getAnimation() {
        return this.getDisplayedAnimation();
    }

    @Override
    public int getAnimationFrame() {
        return this.frame;
    }

    @Override
    public int getId() {
        return this.gfxToDisplay.id;
    }

    @Override
    public void setId(int id) {
        this.gfxId = id;
        this.gfxToDisplay = GraphicsDefinition.fetch(id);
        this.sequenceDefinition = this.gfxToDisplay.animationSequence;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getStartCycle() {
        return this.gfxDisplayCycle;
    }

    @Override
    public int getLevel() {
        return this.gfxHeightLevel;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public boolean finished() {
        return this.isFinished;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(int frame) {
        this.frame = frame;
    }

    @Override
    public int getFrameCycle() {
        return this.cycle;
    }

    @Override
    public void setFrameCycle(int frameCycle) {
        this.cycle = frameCycle;
    }

    @Override
    public void setFinished(boolean finished) {
        this.isFinished = finished;
    }

    @Override
    public void setLevel(int level) {
        this.gfxHeightLevel = level;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public void setHeight(int height) {
        this.z = height;
    }

    @Override
    public RSSequenceDefinition getSequenceDefinition() {
        return null;
    }

    @Override
    public void setSequenceDefinition(RSSequenceDefinition sequenceDefinition) {
        this.sequenceDefinition = (SeqDefinition)((Object)sequenceDefinition);
    }
}

