/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public enum PlayerRights {
    PLAYER(0, "000000", new PlayerRights[0]),
    HELPER(11, "004080", new PlayerRights[0]),
    MODERATOR(1, "#DADADA", HELPER),
    ADMINISTRATOR(2, "F5FF0F", MODERATOR),
    STAFF_MANAGER(3, "4feb34", ADMINISTRATOR),
    DISCORDMANAGER(22, "F5FF0F", new PlayerRights[0]),
    Donator(5, "1B1ABC", new PlayerRights[0]),
    Super_Donator(7, "118120", Donator),
    Great_Donator(9, "6D0000", Super_Donator),
    Extreme_Donator(17, "005C6D", Great_Donator),
    Major_Donator(18, "4a4a4a", Extreme_Donator),
    Supreme_Donator(32, "e38400", Major_Donator),
    Gilded_Donator(8, "e3bd00", Supreme_Donator),
    Platinum_Donator(33, "ffffff", Gilded_Donator),
    Apex_Donator(34, "fb00ff", Platinum_Donator),
    Almighty_Donator(35, "2fff00", Apex_Donator),
    BETA_TESTER(36, "4287f5", Donator),
    RETURN(60, "437100", new PlayerRights[0]),
    HITBOX(12, "437100", new PlayerRights[0]),
    IRONMAN(13, "3A3A3A", new PlayerRights[0]),
    ULTIMATE_IRONMAN(14, "717070", new PlayerRights[0]),
    YOUTUBER(15, "FE0018", new PlayerRights[0]),
    OWNER(16, "A10081", STAFF_MANAGER),
    OSRS(23, "437100", new PlayerRights[0]),
    OSRS_IRONMAN(31, "437100", new PlayerRights[0]),
    ROGUE(25, "437100", new PlayerRights[0]),
    HC_IRONMAN(10, "60201f", new PlayerRights[0]),
    ROGUE_IRONMAN(26, "60201f", new PlayerRights[0]),
    ROGUE_HARDCORE_IRONMAN(27, "60201f", new PlayerRights[0]),
    GROUP_IRONMAN(28, "60201f", new PlayerRights[0]),
    EVENT_MAN(29, "60201f", new PlayerRights[0]),
    COMMUNITY_MANAGER(30, "27FA17", ADMINISTRATOR),
    WILDYMAN(93, "60201f", new PlayerRights[0]),
    GROUP_WILDYMAN(94, "60201f", new PlayerRights[0]),
    LEGENDS(22, "60201f", new PlayerRights[0]),
    HARDCORE_WILDYMAN(94, "60201f", new PlayerRights[0]);

    private final int rightsId;
    private final List<PlayerRights> inherited;
    private final String color;
    private static final Map<PlayerRights, Integer> ICONS;
    private static final PlayerRights[] STAFF_PRIORITY;
    private static final PlayerRights[] DONOR_PRIORITY;
    private static final PlayerRights[] GAMEMODE_PRIORITY;
    public static final EnumSet[] DISPLAY_GROUPS;
    static PlayerRights[] vals;

    private PlayerRights(int right, String color, PlayerRights ... inherited) {
        this.rightsId = right;
        this.inherited = Arrays.asList(inherited);
        this.color = color;
    }

    public boolean isStaffPosition() {
        return this == HELPER || this == ADMINISTRATOR || this == MODERATOR || this == STAFF_MANAGER || this == OWNER || this == COMMUNITY_MANAGER;
    }

    public int getRightsId() {
        return this.rightsId;
    }

    public String getColor() {
        return this.color;
    }

    public int iconIndex() {
        return ICONS.getOrDefault((Object)this, -1);
    }

    public int spriteId() {
        return this.iconIndex();
    }

    public int crownId() {
        return this.iconIndex();
    }

    public boolean hasCrown() {
        return this.iconIndex() >= 0;
    }

    private static PlayerRights firstPresent(Set<PlayerRights> have, PlayerRights[] order) {
        for (PlayerRights r : order) {
            if (!have.contains((Object)r)) continue;
            return r;
        }
        return null;
    }

    public static List<PlayerRights> getDisplayedRights(PlayerRights[] set) {
        PlayerRights mode;
        PlayerRights donor;
        HashSet<PlayerRights> have = new HashSet<PlayerRights>(Arrays.asList(set));
        ArrayList<PlayerRights> out = new ArrayList<PlayerRights>(3);
        PlayerRights staff = PlayerRights.firstPresent(have, STAFF_PRIORITY);
        if (staff != null) {
            out.add(staff);
        }
        if ((donor = PlayerRights.firstPresent(have, DONOR_PRIORITY)) != null) {
            out.add(donor);
        }
        if ((mode = PlayerRights.firstPresent(have, GAMEMODE_PRIORITY)) != null) {
            out.add(mode);
        }
        return out;
    }

    public static PlayerRights forRightsValue(int rightsValue) {
        return Arrays.stream(PlayerRights.values()).filter(r -> r.getRightsId() == rightsValue).findFirst().orElse(PLAYER);
    }

    public static PlayerRights[] ordinalsToArray(int[] ordinals) {
        PlayerRights[] rights = new PlayerRights[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            rights[i] = vals[ordinals[i]];
        }
        return rights;
    }

    public static Pair<Integer, PlayerRights[]> readRightsFromPacket(Buffer inStream) {
        int rightsAmount = inStream.readUnsignedByte();
        int[] ordinals = new int[rightsAmount];
        for (int i = 0; i < rightsAmount; ++i) {
            ordinals[i] = inStream.readUnsignedByte();
            System.out.println("ORDINALS: " + ordinals[i]);
        }
        return Pair.of(rightsAmount, PlayerRights.ordinalsToArray(ordinals));
    }

    public static boolean hasRightsOtherThan(PlayerRights[] rights, PlayerRights playerRight) {
        return Arrays.stream(rights).anyMatch(r -> r != playerRight);
    }

    public static boolean hasRights(PlayerRights[] rights, PlayerRights target) {
        return Arrays.stream(rights).anyMatch(r -> r == target);
    }

    public static boolean hasRightsLevel(PlayerRights[] rights, int rightsId) {
        return Arrays.stream(rights).anyMatch(r -> r.getRightsId() >= rightsId);
    }

    public static boolean hasRightsBetween(PlayerRights[] rights, int low, int high) {
        return Arrays.stream(rights).anyMatch(r -> r.getRightsId() > low && r.getRightsId() < high);
    }

    public static String buildCrownString(List<PlayerRights> rights) {
        return PlayerRights.buildCrownString(rights.toArray(new PlayerRights[0]));
    }

    public static String buildCrownString(PlayerRights[] rights) {
        StringBuilder b = new StringBuilder();
        for (PlayerRights r : PlayerRights.getDisplayedRights(rights)) {
            int idx = r.crownId();
            if (idx < 0) continue;
            b.append("@cr").append(idx).append("@");
        }
        return b.toString();
    }

    public static String buildCrownStringminus(PlayerRights[] rights) {
        StringBuilder b = new StringBuilder();
        for (PlayerRights r : PlayerRights.getDisplayedRights(rights)) {
            int idx = r.crownId();
            if (idx < 0) continue;
            b.append("@cr").append(idx).append("@ ");
        }
        return b.toString().trim();
    }

    static {
        ICONS = new EnumMap<PlayerRights, Integer>(PlayerRights.class);
        ICONS.put(PLAYER, 0);
        ICONS.put(HELPER, 11);
        ICONS.put(MODERATOR, 38);
        ICONS.put(ADMINISTRATOR, 37);
        ICONS.put(STAFF_MANAGER, 3);
        ICONS.put(DISCORDMANAGER, 93);
        ICONS.put(OWNER, 3);
        ICONS.put(COMMUNITY_MANAGER, 99);
        ICONS.put(Donator, 4);
        ICONS.put(Super_Donator, 6);
        ICONS.put(Great_Donator, 8);
        ICONS.put(Extreme_Donator, 5);
        ICONS.put(Major_Donator, 17);
        ICONS.put(Supreme_Donator, 31);
        ICONS.put(Gilded_Donator, 7);
        ICONS.put(Platinum_Donator, 32);
        ICONS.put(Apex_Donator, 16);
        ICONS.put(Almighty_Donator, 40);
        ICONS.put(BETA_TESTER, 35);
        ICONS.put(RETURN, 59);
        ICONS.put(HITBOX, 1);
        ICONS.put(YOUTUBER, 14);
        ICONS.put(LEGENDS, 93);
        ICONS.put(IRONMAN, 12);
        ICONS.put(ULTIMATE_IRONMAN, 13);
        ICONS.put(HC_IRONMAN, 9);
        ICONS.put(GROUP_IRONMAN, 27);
        ICONS.put(EVENT_MAN, 92);
        ICONS.put(OSRS, 92);
        ICONS.put(OSRS_IRONMAN, 92);
        ICONS.put(ROGUE, 92);
        ICONS.put(ROGUE_IRONMAN, 92);
        ICONS.put(ROGUE_HARDCORE_IRONMAN, 9);
        ICONS.put(WILDYMAN, 92);
        ICONS.put(GROUP_WILDYMAN, 92);
        ICONS.put(HARDCORE_WILDYMAN, 92);
        STAFF_PRIORITY = new PlayerRights[]{OWNER, STAFF_MANAGER, ADMINISTRATOR, MODERATOR, HELPER, COMMUNITY_MANAGER, DISCORDMANAGER, YOUTUBER, BETA_TESTER, RETURN};
        DONOR_PRIORITY = new PlayerRights[]{Almighty_Donator, Apex_Donator, Platinum_Donator, Gilded_Donator, Supreme_Donator, Major_Donator, Extreme_Donator, Great_Donator, Super_Donator, Donator};
        GAMEMODE_PRIORITY = new PlayerRights[]{LEGENDS, HC_IRONMAN, ULTIMATE_IRONMAN, IRONMAN, GROUP_IRONMAN, HARDCORE_WILDYMAN, WILDYMAN, OSRS_IRONMAN, OSRS, ROGUE_HARDCORE_IRONMAN, ROGUE_IRONMAN, ROGUE, EVENT_MAN};
        DISPLAY_GROUPS = new EnumSet[]{EnumSet.of(LEGENDS, new PlayerRights[]{HELPER, RETURN, BETA_TESTER, MODERATOR, ADMINISTRATOR, COMMUNITY_MANAGER, OWNER, STAFF_MANAGER, Donator, Super_Donator, Great_Donator, Extreme_Donator, Major_Donator, Supreme_Donator, Gilded_Donator, Platinum_Donator, Apex_Donator, Almighty_Donator, YOUTUBER}), EnumSet.of(HITBOX, new PlayerRights[]{EVENT_MAN, IRONMAN, ULTIMATE_IRONMAN, OSRS, OSRS_IRONMAN, DISCORDMANAGER, HC_IRONMAN, ROGUE, ROGUE_HARDCORE_IRONMAN, ROGUE_IRONMAN, GROUP_IRONMAN, WILDYMAN, HARDCORE_WILDYMAN})};
        vals = PlayerRights.values();
    }
}

