/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Cacheable;
import com.client.NodeCache;
import com.client.NodeSubList;
import com.client.sign.Signlink;

public final class ReferenceCache {
    private final Cacheable emptyNodeSub = new Cacheable();
    private final int initialCount;
    private int spaceLeft;
    private final NodeCache nodeCache;
    private final NodeSubList nodeSubList = new NodeSubList();

    public ReferenceCache(int i) {
        this.initialCount = i;
        this.spaceLeft = i;
        this.nodeCache = new NodeCache();
    }

    public Cacheable get(long l) {
        Cacheable nodeSub = (Cacheable)this.nodeCache.findNodeByID(l);
        if (nodeSub != null) {
            this.nodeSubList.insertHead(nodeSub);
        }
        return nodeSub;
    }

    public void put(Cacheable nodeSub, long l) {
        try {
            if (this.spaceLeft == 0) {
                Cacheable nodeSub_1 = this.nodeSubList.popTail();
                if (nodeSub_1 != null) {
                    nodeSub_1.remove();
                    nodeSub_1.unlinkSub();
                    if (nodeSub_1 == this.emptyNodeSub) {
                        Cacheable nodeSub_2 = this.nodeSubList.popTail();
                        nodeSub_2.remove();
                        nodeSub_2.unlinkSub();
                    }
                } else {
                    this.unlinkAll();
                }
            } else {
                --this.spaceLeft;
            }
            this.nodeCache.removeFromCache(nodeSub, l);
            this.nodeSubList.insertHead(nodeSub);
            return;
        }
        catch (RuntimeException runtimeexception) {
            runtimeexception.printStackTrace();
            Signlink.reporterror("47547, " + nodeSub + ", " + l + ", 2, " + runtimeexception.toString());
            this.unlinkAll();
            return;
        }
    }

    public void unlinkAll() {
        Cacheable nodeSub;
        while ((nodeSub = this.nodeSubList.popTail()) != null) {
            nodeSub.remove();
            nodeSub.unlinkSub();
        }
        this.spaceLeft = this.initialCount;
    }
}

