/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.client.audio.VoiceChat;
import com.client.audio.VoicePlayback;
import com.client.audio.VoiceSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class VoiceSettingsGUI
extends JFrame {
    private static VoiceSettingsGUI instance;
    private JComboBox<String> microphoneComboBox;
    private JComboBox<String> speakerComboBox;
    private JCheckBox loopbackCheckBox;
    private JLabel activeMicLabel;
    private JLabel activeSpeakerLabel;
    private JSlider micVolumeSlider;
    private JLabel micVolumeLabel;
    private VoiceChat voiceChat = VoiceChat.getInstance();
    private VoicePlayback voicePlayback = VoicePlayback.getInstance();

    private VoiceSettingsGUI() {
        this.initializeGUI();
    }

    public static VoiceSettingsGUI getInstance() {
        if (instance == null) {
            instance = new VoiceSettingsGUI();
        }
        return instance;
    }

    private void initializeGUI() {
        this.setTitle("Voice Chat Settings");
        this.setSize(500, 500);
        this.setDefaultCloseOperation(1);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel titleLabel = new JLabel("Voice Chat Settings");
        titleLabel.setFont(new Font("Arial", 1, 18));
        titleLabel.setAlignmentX(0.5f);
        mainPanel.add(titleLabel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JPanel micPanel = new JPanel(new BorderLayout(10, 5));
        micPanel.setBorder(BorderFactory.createTitledBorder("Microphone"));
        JLabel micLabel = new JLabel("Select Microphone:");
        this.microphoneComboBox = new JComboBox();
        this.populateMicrophones();
        this.microphoneComboBox.addActionListener(e -> this.onMicrophoneChanged());
        this.activeMicLabel = new JLabel("Active: " + this.voiceChat.getCurrentMicrophoneInfo());
        this.activeMicLabel.setFont(new Font("Arial", 0, 11));
        micPanel.add((Component)micLabel, "North");
        micPanel.add(this.microphoneComboBox, "Center");
        micPanel.add((Component)this.activeMicLabel, "South");
        mainPanel.add(micPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel micVolumePanel = new JPanel(new BorderLayout(10, 5));
        micVolumePanel.setBorder(BorderFactory.createTitledBorder("Microphone Volume"));
        JPanel sliderPanel = new JPanel(new BorderLayout());
        this.micVolumeLabel = new JLabel("Volume: " + this.voiceChat.getMicrophoneVolumePercent() + "%");
        this.micVolumeLabel.setHorizontalAlignment(0);
        this.micVolumeSlider = new JSlider(0, 0, 200, this.voiceChat.getMicrophoneVolumePercent());
        this.micVolumeSlider.setMajorTickSpacing(50);
        this.micVolumeSlider.setMinorTickSpacing(10);
        this.micVolumeSlider.setPaintTicks(true);
        this.micVolumeSlider.setPaintLabels(true);
        this.micVolumeSlider.addChangeListener(e -> this.onMicVolumeChanged());
        sliderPanel.add((Component)this.micVolumeLabel, "North");
        sliderPanel.add((Component)this.micVolumeSlider, "Center");
        micVolumePanel.add((Component)sliderPanel, "Center");
        mainPanel.add(micVolumePanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel speakerPanel = new JPanel(new BorderLayout(10, 5));
        speakerPanel.setBorder(BorderFactory.createTitledBorder("Speaker"));
        JLabel speakerLabel = new JLabel("Select Speaker:");
        this.speakerComboBox = new JComboBox();
        this.populateSpeakers();
        this.speakerComboBox.addActionListener(e -> this.onSpeakerChanged());
        this.activeSpeakerLabel = new JLabel("Active: " + this.voicePlayback.getCurrentSpeakerInfo());
        this.activeSpeakerLabel.setFont(new Font("Arial", 0, 11));
        speakerPanel.add((Component)speakerLabel, "North");
        speakerPanel.add(this.speakerComboBox, "Center");
        speakerPanel.add((Component)this.activeSpeakerLabel, "South");
        mainPanel.add(speakerPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel loopbackPanel = new JPanel(new FlowLayout(0));
        loopbackPanel.setBorder(BorderFactory.createTitledBorder("Test Mode"));
        this.loopbackCheckBox = new JCheckBox("Enable Loopback (hear your own voice)");
        this.loopbackCheckBox.setSelected(this.voiceChat.isLoopbackMode());
        this.loopbackCheckBox.addActionListener(e -> this.onLoopbackToggled());
        loopbackPanel.add(this.loopbackCheckBox);
        mainPanel.add(loopbackPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        JLabel infoLabel = new JLabel("<html><center>Press and hold Ctrl + V in-game to start voice chat<br>Changes take effect immediately</center></html>");
        infoLabel.setFont(new Font("Arial", 2, 11));
        infoLabel.setAlignmentX(0.5f);
        mainPanel.add(infoLabel);
        this.add(mainPanel);
    }

    private void populateMicrophones() {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.microphoneComboBox.getActionListeners()) {
            this.microphoneComboBox.removeActionListener(listener);
        }
        this.microphoneComboBox.removeAllItems();
        Mixer.Info[] microphones = this.voiceChat.getAvailableMicrophones();
        for (int i = 0; i < microphones.length; ++i) {
            String name = i + 1 + ". " + microphones[i].getName();
            this.microphoneComboBox.addItem(name);
        }
        int selectedIndex = this.voiceChat.getSelectedMicIndex();
        if (selectedIndex >= 0 && selectedIndex < microphones.length) {
            this.microphoneComboBox.setSelectedIndex(selectedIndex);
        }
        for (ActionListener listener : listeners) {
            this.microphoneComboBox.addActionListener(listener);
        }
    }

    private void populateSpeakers() {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.speakerComboBox.getActionListeners()) {
            this.speakerComboBox.removeActionListener(listener);
        }
        this.speakerComboBox.removeAllItems();
        Mixer.Info[] speakers = this.voicePlayback.getAvailableSpeakers();
        for (int i = 0; i < speakers.length; ++i) {
            String name = i + 1 + ". " + speakers[i].getName();
            this.speakerComboBox.addItem(name);
        }
        int selectedIndex = this.voicePlayback.getSelectedSpeakerIndex();
        if (selectedIndex >= 0 && selectedIndex < speakers.length) {
            this.speakerComboBox.setSelectedIndex(selectedIndex);
        }
        for (ActionListener listener : listeners) {
            this.speakerComboBox.addActionListener(listener);
        }
    }

    private void onMicrophoneChanged() {
        int selectedIndex = this.microphoneComboBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            String result2 = this.voiceChat.setMicrophone(selectedIndex);
            this.activeMicLabel.setText("Active: " + this.voiceChat.getCurrentMicrophoneInfo());
            System.out.println("[VOICE SETTINGS] " + result2);
            this.saveSettings();
        }
    }

    private void onSpeakerChanged() {
        int selectedIndex = this.speakerComboBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            String result2 = this.voicePlayback.setSpeaker(selectedIndex);
            this.activeSpeakerLabel.setText("Active: " + this.voicePlayback.getCurrentSpeakerInfo());
            System.out.println("[VOICE SETTINGS] " + result2);
            this.saveSettings();
        }
    }

    private void onLoopbackToggled() {
        boolean enabled = this.loopbackCheckBox.isSelected();
        this.voiceChat.toggleLoopbackMode();
        System.out.println("[VOICE SETTINGS] Loopback mode " + (enabled ? "enabled" : "disabled"));
        this.saveSettings();
    }

    private void onMicVolumeChanged() {
        int volume = this.micVolumeSlider.getValue();
        this.voiceChat.setMicrophoneVolumePercent(volume);
        this.micVolumeLabel.setText("Volume: " + volume + "%");
        System.out.println("[VOICE SETTINGS] Microphone volume set to " + volume + "%");
        this.saveSettings();
    }

    private void saveSettings() {
        VoiceSettings settings = VoiceSettings.fromCurrent();
        settings.save();
    }

    public void showWindow() {
        this.populateMicrophones();
        this.populateSpeakers();
        this.activeMicLabel.setText("Active: " + this.voiceChat.getCurrentMicrophoneInfo());
        this.activeSpeakerLabel.setText("Active: " + this.voicePlayback.getCurrentSpeakerInfo());
        this.loopbackCheckBox.setSelected(this.voiceChat.isLoopbackMode());
        int currentVolume = this.voiceChat.getMicrophoneVolumePercent();
        this.micVolumeSlider.setValue(currentVolume);
        this.micVolumeLabel.setText("Volume: " + currentVolume + "%");
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
    }

    public void hideWindow() {
        this.setVisible(false);
    }
}

