/*
 * Decompiled with CFR 0.152.
 */
package com.client.broadcast;

import com.client.Client;
import com.client.broadcast.Broadcast;

public class BroadcastManager {
    public static Broadcast[] broadcasts = new Broadcast[1000];

    public static void removeIndex(int broadcastIndex) {
        if (broadcasts[broadcastIndex] != null) {
            BroadcastManager.broadcasts[broadcastIndex] = null;
        }
    }

    public static Broadcast getCurrentBroadcast() {
        Broadcast b = broadcasts[BroadcastManager.getHighestIndex()];
        if (b == null || b.message == null) {
            return null;
        }
        if (b.time < System.currentTimeMillis()) {
            return null;
        }
        return b;
    }

    public static void addBoradcast(Broadcast broadcast2) {
        BroadcastManager.broadcasts[broadcast2.index] = broadcast2;
    }

    public static Broadcast getBroadCast(String message) {
        for (Broadcast b : broadcasts) {
            if (b == null || b.message == null || !b.message.equalsIgnoreCase(message)) continue;
            return b;
        }
        return null;
    }

    private static int getBroadcastSize() {
        int count2 = 0;
        for (Broadcast b : broadcasts) {
            if (b == null || b.message == null) continue;
            ++count2;
        }
        return count2;
    }

    public static int getHighestIndex() {
        int highestIndex = 0;
        for (Broadcast b : broadcasts) {
            if (b == null || b.message == null || highestIndex >= b.index) continue;
            highestIndex = b.index;
        }
        return highestIndex;
    }

    public static boolean isDisplayed() {
        Broadcast b = broadcasts[BroadcastManager.getHighestIndex()];
        if (b == null || b.message == null) {
            return false;
        }
        return b.time > System.currentTimeMillis();
    }

    public static void display(Client client) {
        int yPosition;
        Broadcast b = broadcasts[BroadcastManager.getHighestIndex()];
        if (b == null || b.message == null) {
            return;
        }
        if (b.time < System.currentTimeMillis()) {
            return;
        }
        int n = !Client.instance.isResized() ? 330 : (yPosition = Client.canvasHeight - 173);
        if (client.isServerUpdating()) {
            yPosition -= 13;
        }
        client.newRegularFont.drawBasicString(b.getDecoratedMessage(), !Client.instance.isResized() ? 5 : 0, yPosition, 0xFFFF00, 0);
    }
}

