/*
 * Decompiled with CFR 0.152.
 */
package com.client.cache;

import com.client.cache.CacheDownloader;
import com.client.cache.Progress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001e\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010%\u001a\u00020\u0010H\u0002J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\u0010H\u0002J\u0018\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003H\u0002J\b\u00104\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u00020\u0006H\u0002J\b\u00106\u001a\u00020\u0010H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u00067"}, d2={"Lcom/client/cache/CacheDownloader;", "", "path", "", "url", "updateCheck", "", "writeOnlineHash", "listener", "Lcom/client/cache/Progress;", "(Ljava/lang/String;Ljava/lang/String;ZZLcom/client/cache/Progress;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "deferredTasks", "", "Lkotlinx/coroutines/Deferred;", "", "getPath", "()Ljava/lang/String;", "update", "getUpdate", "()Ljava/util/List;", "setUpdate", "(Ljava/util/List;)V", "getUpdateCheck", "()Z", "setUpdateCheck", "(Z)V", "getUrl", "getWriteOnlineHash", "awaitCompletion", "checkAndExtractZip", "zipFileName", "outputDirectoryName", "download", "name", "downloadAsync", "extractOsrsDecodedDataZip", "extractZipFile", "zipFile", "Ljava/io/File;", "outputDirectory", "generateList", "getHash", "file", "Ljava/nio/file/Path;", "getOnlineHash", "Ljava/net/URL;", "initialize", "needsDownload", "location", "hash", "recheckAndDownloadMissingFiles", "updateFiles", "writeHashes", "game"})
@SourceDebugExtension(value={"SMAP\nCacheDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheDownloader.kt\ncom/client/cache/CacheDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,345:1\n1855#2,2:346\n1855#2,2:348\n1855#2,2:350\n1855#2,2:352\n1#3:354\n1295#4,2:355\n*S KotlinDebug\n*F\n+ 1 CacheDownloader.kt\ncom/client/cache/CacheDownloader\n*L\n53#1:346,2\n137#1:348,2\n150#1:350,2\n172#1:352,2\n275#1:355,2\n*E\n"})
public final class CacheDownloader {
    @NotNull
    private final String path;
    @NotNull
    private final String url;
    private boolean updateCheck;
    private final boolean writeOnlineHash;
    @Nullable
    private final Progress listener;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final List<Deferred<Unit>> deferredTasks;
    @NotNull
    private List<String> update;

    public CacheDownloader(@NotNull String path, @NotNull String url, boolean updateCheck, boolean writeOnlineHash, @Nullable Progress listener) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(url, "url");
        this.path = path;
        this.url = url;
        this.updateCheck = updateCheck;
        this.writeOnlineHash = writeOnlineHash;
        this.listener = listener;
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        Intrinsics.checkNotNullExpressionValue(executorService, "newFixedThreadPool(4)");
        this.coroutineScope = CoroutineScopeKt.CoroutineScope(ExecutorsKt.from(executorService));
        this.deferredTasks = new ArrayList();
        this.update = new ArrayList();
        if (this.writeOnlineHash) {
            this.updateCheck = false;
            this.writeHashes();
        }
        this.initialize();
    }

    public /* synthetic */ CacheDownloader(String string2, String string3, boolean bl, boolean bl2, Progress progress, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            progress = new Progress(){

                @Override
                public void update(int progress, @NotNull String message) {
                    Intrinsics.checkNotNullParameter(message, "message");
                    System.out.print((Object)("\r [" + progress + "] " + message));
                }
            };
        }
        this(string2, string3, bl, bl2, progress);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final boolean getUpdateCheck() {
        return this.updateCheck;
    }

    public final void setUpdateCheck(boolean bl) {
        this.updateCheck = bl;
    }

    public final boolean getWriteOnlineHash() {
        return this.writeOnlineHash;
    }

    @NotNull
    public final List<String> getUpdate() {
        return this.update;
    }

    public final void setUpdate(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.update = list;
    }

    /*
     * Unable to fully structure code
     */
    private final void initialize() {
        block12: {
            v0 = this.listener;
            if (v0 != null) {
                v0.update(0, "Looking for Updates...");
            }
            if (!this.updateFiles() || !this.updateCheck) break block12;
            v1 = this.listener;
            if (v1 != null) {
                v1.update(0, "Updates found...");
            }
            this.generateList();
            $this$forEach$iv = this.update;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block13: {
                    it = (String)element$iv;
                    $i$a$-forEach-CacheDownloader$initialize$1 = false;
                    this.download(this.url + it, this.path + it);
                    switch (it.hashCode()) {
                        case -326051977: {
                            if (it.equals("sounds.zip")) break;
                            ** break;
                        }
                        case 1160643527: {
                            if (!it.equals("Decoded Data.zip")) {
                                ** break;
                            }
                            break block13;
                        }
                        case 264912769: {
                            if (!it.equals("sprites.zip") || !(spritesFolder = new File(this.path, "sprites")).exists()) ** break;
                            FilesKt.deleteRecursively(spritesFolder);
                            ** break;
                        }
                    }
                    soundsFolder = new File(this.path, "sounds");
                    if (!soundsFolder.exists()) ** break;
                    FilesKt.deleteRecursively(soundsFolder);
                    ** break;
                }
                decodedDataFolder = new File(this.path, "osrs/Decoded Data");
                if (!decodedDataFolder.exists()) ** break;
                FilesKt.deleteRecursively(decodedDataFolder);
lbl38:
                // 9 sources

            }
            this.recheckAndDownloadMissingFiles();
            spritesZipFile = new File(this.path, "sprites.zip");
            if (spritesZipFile.exists()) {
                this.checkAndExtractZip("sprites.zip", ".");
            }
            if ((decodedZipFile = new File(this.path, "osrs/Decoded Data.zip")).exists()) {
                this.extractZipFile(decodedZipFile, new File(this.path, "osrs"));
                decodedZipFile.delete();
            }
            if ((soundsZipFile = new File(this.path, "sounds.zip")).exists() && !(soundsFolder = new File(this.path, "sounds")).exists()) {
                this.checkAndExtractZip("sounds.zip", ".");
            }
            this.writeHashes();
        }
    }

    private final void extractOsrsDecodedDataZip() {
        File zipFile = new File(this.path, "osrs/Decoded Data.zip");
        File outputDirectory = new File(this.path, "osrs");
        if (zipFile.exists()) {
            System.out.println((Object)("Extracting " + zipFile.getAbsolutePath()));
            if (outputDirectory.exists()) {
                System.out.println((Object)("Cleaning existing contents in " + outputDirectory.getAbsolutePath()));
                FilesKt.deleteRecursively(outputDirectory);
            }
            outputDirectory.mkdirs();
            this.extractZipFile(zipFile, outputDirectory);
        } else {
            System.out.println((Object)"Decoded Data.zip not found in osrs/ directory");
        }
    }

    private final void recheckAndDownloadMissingFiles() {
        block4: {
            block3: {
                Object it;
                JSONParser jsonParser = new JSONParser();
                URL link = new URL(this.url + "online_hashes.json");
                InputStream inputStream2 = link.openConnection().getInputStream();
                Object object = jsonParser.parse(TextStreamsKt.readText(new InputStreamReader(inputStream2)));
                Intrinsics.checkNotNullExpressionValue(object, "jsonParser.parse(InputSt\u2026(inputStream).readText())");
                Object obj2 = object;
                JSONArray list = (JSONArray)obj2;
                List missingFiles = new ArrayList();
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.json.simple.JSONObject");
                    JSONObject raw = (JSONObject)it;
                    Object v = raw.get("data");
                    Intrinsics.checkNotNull(v, "null cannot be cast to non-null type org.json.simple.JSONObject");
                    JSONObject data2 = (JSONObject)v;
                    Object v2 = data2.get("name");
                    Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type kotlin.String");
                    String name = (String)v2;
                    Object v3 = data2.get("hash");
                    Intrinsics.checkNotNull(v3, "null cannot be cast to non-null type kotlin.String");
                    String hash = (String)v3;
                    Object v4 = data2.get("location");
                    Intrinsics.checkNotNull(v4, "null cannot be cast to non-null type kotlin.String");
                    String location = (String)v4;
                    if (!this.needsDownload(location, hash) || Intrinsics.areEqual(name, "hashes.json")) continue;
                    missingFiles.add(location);
                }
                if (!(!((Collection)missingFiles).isEmpty())) break block3;
                Progress progress = this.listener;
                if (progress != null) {
                    progress.update(0, "Rechecking and downloading missing files...");
                }
                $this$forEach$iv = missingFiles;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    this.download(this.url + it, this.path + it);
                }
                Progress progress2 = this.listener;
                if (progress2 == null) break block4;
                progress2.update(100, "Recheck and download complete");
                break block4;
            }
            Progress progress = this.listener;
            if (progress == null) break block4;
            progress.update(100, "No missing files found");
        }
    }

    private final void downloadAsync(String url, String path) {
        this.download(url, path);
    }

    private final void generateList() {
        Progress progress = this.listener;
        if (progress != null) {
            progress.update(0, "Generating Patch List...");
        }
        JSONParser jsonParser = new JSONParser();
        URL link = new URL(this.url + "online_hashes.json");
        URLConnection inputStream2 = link.openConnection();
        Object object = jsonParser.parse(TextStreamsKt.readText(new InputStreamReader(inputStream2.getInputStream())));
        Intrinsics.checkNotNullExpressionValue(object, "jsonParser.parse(InputSt\u2026nputStream()).readText())");
        Object obj2 = object;
        JSONArray list = (JSONArray)obj2;
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.json.simple.JSONObject");
            JSONObject raw = (JSONObject)it;
            Object v = raw.get("data");
            Intrinsics.checkNotNull(v, "null cannot be cast to non-null type org.json.simple.JSONObject");
            JSONObject data2 = (JSONObject)v;
            Object v2 = data2.get("name");
            Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type kotlin.String");
            String name = (String)v2;
            Object v3 = data2.get("hash");
            Intrinsics.checkNotNull(v3, "null cannot be cast to non-null type kotlin.String");
            String hash = (String)v3;
            Object v4 = data2.get("location");
            Intrinsics.checkNotNull(v4, "null cannot be cast to non-null type kotlin.String");
            String location = (String)v4;
            if (!this.needsDownload(location, hash) || Intrinsics.areEqual(name, "hashes.json")) continue;
            this.update.add(location);
        }
        Progress progress2 = this.listener;
        if (progress2 != null) {
            progress2.setSize(this.update.size());
        }
    }

    private final boolean needsDownload(String location, String hash) {
        boolean bl;
        if (!new File(this.path, location).exists()) {
            bl = true;
        } else {
            Path path = new File(this.path, location).toPath();
            Intrinsics.checkNotNullExpressionValue(path, "File(path, location).toPath()");
            bl = !Intrinsics.areEqual(this.getHash(path), hash);
        }
        return bl;
    }

    private final boolean updateFiles() {
        boolean bl;
        if (!new File(this.path, "hashes.json").exists()) {
            bl = true;
        } else {
            String string2 = this.getOnlineHash(new URL(this.url + "cache.php?name=online_hashes.json"));
            Path path = new File(this.path, "hashes.json").toPath();
            Intrinsics.checkNotNullExpressionValue(path, "File(path, \"hashes.json\").toPath()");
            bl = !Intrinsics.areEqual(string2, this.getHash(path));
        }
        return bl;
    }

    private final String getOnlineHash(URL url) {
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        if (((HttpURLConnection)uRLConnection).getResponseCode() == 404) {
            throw new IllegalStateException(("Could not locate cache.php at " + url).toString());
        }
        String hash = TextStreamsKt.readText(new InputStreamReader(url.openStream()));
        if (StringsKt.isBlank(hash)) {
            throw new IllegalStateException("Could not find the file you requested".toString());
        }
        return hash;
    }

    private final String getHash(Path file) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(Files.readAllBytes(file));
        byte[] digest = md.digest();
        String string2 = DatatypeConverter.printHexBinary(digest);
        Intrinsics.checkNotNullExpressionValue(string2, "printHexBinary(digest)");
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase()");
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void download(String name, String path) {
        InputStream inputStream2 = null;
        OutputStream outputStream2 = null;
        try {
            URL url = new URL(StringsKt.replace$default(name, " ", "%20", false, 4, null));
            String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36";
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNullExpressionValue(uRLConnection, "url.openConnection()");
            URLConnection con = uRLConnection;
            con.setRequestProperty("User-Agent", userAgent);
            int contentLength = con.getContentLength();
            inputStream2 = new BufferedInputStream(con.getInputStream());
            new File(StringsKt.substringBeforeLast$default(path, "/", null, 2, null)).mkdirs();
            outputStream2 = new BufferedOutputStream(new FileOutputStream(path));
            byte[] buffer = new byte[8192];
            int length = 0;
            int downloaded = 0;
            while (true) {
                int n;
                int it = n = ((BufferedInputStream)inputStream2).read(buffer);
                boolean bl = false;
                length = it;
                if (n != -1) {
                    ((BufferedOutputStream)outputStream2).write(buffer, 0, length);
                    downloaded += length;
                    Progress progress = this.listener;
                    if (progress != null) {
                        progress.setFileName(StringsKt.substringAfterLast$default(name, "/", null, 2, null));
                    }
                    Progress progress2 = this.listener;
                    if (progress2 != null) {
                        progress2.setLink(name);
                    }
                    Progress progress3 = this.listener;
                    if (progress3 == null) continue;
                    int n2 = (int)((double)downloaded * 100.0 / ((double)contentLength * 1.0));
                    String string2 = name.substring(StringsKt.lastIndexOf$default((CharSequence)name, '/', 0, false, 6, null) + 1);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                    progress3.update(n2, "Downloading " + string2 + "...");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            try {
                throw new IllegalStateException(((Object)ex).toString());
            }
            catch (Throwable throwable) {
                try {
                    InputStream inputStream3 = inputStream2;
                    if (inputStream3 != null) {
                        inputStream3.close();
                    }
                    OutputStream outputStream3 = outputStream2;
                    if (outputStream3 == null) throw throwable;
                    outputStream3.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            inputStream2.close();
            outputStream2.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public final void checkAndExtractZip(@NotNull String zipFileName, @NotNull String outputDirectoryName) {
        Intrinsics.checkNotNullParameter(zipFileName, "zipFileName");
        Intrinsics.checkNotNullParameter(outputDirectoryName, "outputDirectoryName");
        File zipFile = new File(this.path, zipFileName);
        if (zipFile.exists()) {
            System.out.println((Object)("Extracting " + zipFileName));
            System.out.println((Object)("Extracting " + zipFile.getAbsoluteFile()));
            File outputDirectory = new File(this.path, outputDirectoryName);
            this.extractZipFile(zipFile, outputDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractZipFile(File zipFile, File outputDirectory) {
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipFile zip2 = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zip2.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "zip.entries()");
            Sequence<? extends ZipEntry> sequence = SequencesKt.asSequence(CollectionsKt.iterator(enumeration));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl2 = false;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "entry.name");
                if (StringsKt.startsWith$default(string2, "__MACOSX", false, 2, null)) continue;
                File entryFile = new File(outputDirectory, entry.getName());
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                Closeable closeable2 = zip2.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    InputStream input = (InputStream)closeable2;
                    boolean bl3 = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(input, entryFile.toPath(), copyOptionArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeHashes() {
        JSONArray list = new JSONArray();
        Path rootPath = Paths.get(this.path, new String[0]);
        Files.walk(rootPath, new FileVisitOption[0]).filter(arg_0 -> CacheDownloader.writeHashes$lambda$8(writeHashes.1.INSTANCE, arg_0)).filter(arg_0 -> CacheDownloader.writeHashes$lambda$9(writeHashes.2.INSTANCE, arg_0)).forEach(arg_0 -> CacheDownloader.writeHashes$lambda$10(new Function1<Path, Unit>(rootPath, this, list){
            final /* synthetic */ Path $rootPath;
            final /* synthetic */ CacheDownloader this$0;
            final /* synthetic */ JSONArray $list;
            {
                this.$rootPath = $rootPath;
                this.this$0 = $receiver;
                this.$list = $list;
                super(1);
            }

            public final void invoke(Path it) {
                JSONObject data2 = new JSONObject();
                ((Map)data2).put("name", ((Object)it.getFileName()).toString());
                ((Map)data2).put("location", StringsKt.replace$default(((Object)this.$rootPath.relativize(it)).toString(), "\\", "/", false, 4, null));
                Map map2 = data2;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                map2.put("hash", CacheDownloader.access$getHash(this.this$0, it));
                JSONObject write2 = new JSONObject();
                ((Map)write2).put("data", data2);
                this.$list.add(write2);
            }
        }, arg_0));
        try {
            Closeable closeable = new FileWriter((String)(this.writeOnlineHash ? "online_hashes.json" : this.path + "hashes.json"));
            Throwable throwable = null;
            try {
                FileWriter file = (FileWriter)closeable;
                boolean bl = false;
                file.write(list.toJSONString());
                file.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.writeOnlineHash) {
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public final void awaitCompletion() {
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CacheDownloader this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ CacheDownloader this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(var1_1);
                                        $this$forEach$iv = CacheDownloader.access$getDeferredTasks$p(this.this$0);
                                        $i$f$forEach = false;
                                        var4_5 = $this$forEach$iv.iterator();
lbl8:
                                        // 3 sources

                                        while (var4_5.hasNext()) {
                                            element$iv = var4_5.next();
                                            deferred = (Deferred)element$iv;
                                            $i$a$-forEach-CacheDownloader$awaitCompletion$1$1$1 = false;
                                            this.L$0 = var4_5;
                                            this.label = 1;
                                            v0 = deferred.await(this);
                                            if (v0 != var8_2) continue;
                                            return var8_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$f$forEach = false;
                                        $i$a$-forEach-CacheDownloader$awaitCompletion$1$1$1 = false;
                                        var4_5 = (Iterator<T>)this.L$0;
                                        ResultKt.throwOnFailure($result);
                                        v0 = $result;
                                        ** GOTO lbl8
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private static final boolean writeHashes$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean writeHashes$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void writeHashes$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getHash(CacheDownloader $this, Path file) {
        return $this.getHash(file);
    }

    public static final /* synthetic */ List access$getDeferredTasks$p(CacheDownloader $this) {
        return $this.deferredTasks;
    }
}

