/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.definitions.SeqBase;
import com.client.osrs.OSRSCacheLoader;
import java.util.Arrays;

public class SeqFrame {
    private int frameFileId;
    private int[] xModifier;
    private int[] yModifier;
    private int[] zModifier;
    private int[] bases;
    private int baseCount;
    private SeqBase base;
    private int frameCount;

    public static SeqFrame get(int id) {
        return OSRSCacheLoader.getSeqFrame(id);
    }

    public static boolean isLoaded(int id) {
        return OSRSCacheLoader.getSeqFrameDefs().getDefinitions().containsKey(id >> 16);
    }

    public static SeqFrame forID(int id) {
        return OSRSCacheLoader.getSeqFrame(id);
    }

    public static boolean noAnimationInProgress(int frame) {
        return frame == -1;
    }

    public int getFrameFileId() {
        return this.frameFileId;
    }

    public int[] getXModifier() {
        return this.xModifier;
    }

    public int[] getYModifier() {
        return this.yModifier;
    }

    public int[] getZModifier() {
        return this.zModifier;
    }

    public int[] getBases() {
        return this.bases;
    }

    public int getBaseCount() {
        return this.baseCount;
    }

    public SeqBase getBase() {
        return this.base;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameFileId(int frameFileId) {
        this.frameFileId = frameFileId;
    }

    public void setXModifier(int[] xModifier) {
        this.xModifier = xModifier;
    }

    public void setYModifier(int[] yModifier) {
        this.yModifier = yModifier;
    }

    public void setZModifier(int[] zModifier) {
        this.zModifier = zModifier;
    }

    public void setBases(int[] bases) {
        this.bases = bases;
    }

    public void setBaseCount(int baseCount) {
        this.baseCount = baseCount;
    }

    public void setBase(SeqBase base) {
        this.base = base;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeqFrame)) {
            return false;
        }
        SeqFrame other = (SeqFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrameFileId() != other.getFrameFileId()) {
            return false;
        }
        if (this.getBaseCount() != other.getBaseCount()) {
            return false;
        }
        if (this.getFrameCount() != other.getFrameCount()) {
            return false;
        }
        if (!Arrays.equals(this.getXModifier(), other.getXModifier())) {
            return false;
        }
        if (!Arrays.equals(this.getYModifier(), other.getYModifier())) {
            return false;
        }
        if (!Arrays.equals(this.getZModifier(), other.getZModifier())) {
            return false;
        }
        if (!Arrays.equals(this.getBases(), other.getBases())) {
            return false;
        }
        SeqBase this$base = this.getBase();
        SeqBase other$base = other.getBase();
        return !(this$base == null ? other$base != null : !((Object)this$base).equals(other$base));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeqFrame;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getFrameFileId();
        result2 = result2 * 59 + this.getBaseCount();
        result2 = result2 * 59 + this.getFrameCount();
        result2 = result2 * 59 + Arrays.hashCode(this.getXModifier());
        result2 = result2 * 59 + Arrays.hashCode(this.getYModifier());
        result2 = result2 * 59 + Arrays.hashCode(this.getZModifier());
        result2 = result2 * 59 + Arrays.hashCode(this.getBases());
        SeqBase $base = this.getBase();
        result2 = result2 * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        return result2;
    }

    public String toString() {
        return "SeqFrame(frameFileId=" + this.getFrameFileId() + ", xModifier=" + Arrays.toString(this.getXModifier()) + ", yModifier=" + Arrays.toString(this.getYModifier()) + ", zModifier=" + Arrays.toString(this.getZModifier()) + ", bases=" + Arrays.toString(this.getBases()) + ", baseCount=" + this.getBaseCount() + ", base=" + this.getBase() + ", frameCount=" + this.getFrameCount() + ")";
    }
}

