/*
 * Decompiled with CFR 0.152.
 */
package com.client.util;

import com.client.util.Stopwatch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Strings {
    private static final String[] searchList = new String[]{"@pur@", "@red@", "@gre@", "@blu@", "@yel@", "@cya@", "@mag@", "@whi@", "@lre@", "@dre@", "@bla@", "@or0@", "@or1@", "@or2@", "@or3@", "@gr0@", "@gr1@", "@gr2@", "@gr3@", "@gra@", "@OR0", "@PUR@", "@RED@", "@GRE@", "@BLU@", "@YEL@", "@CYA@", "@MAG@", "@WHI@", "@LRE@", "@DRE@", "@BLA@", "@OR1@", "@OR2@", "@OR3@", "@GR1@", "@GR2@", "@GR3@"};
    private static final String[] replacementList = new String[]{"<col=A10081>", "<col=ff0000>", "<col=FF00>", "<col=ff>", "<col=ffff00>", "<col=ffff>", "<col=ff00ff>", "<col=ffffff>", "<col=ff9040>", "<col=800000>", "<col=0>", "<col=A67711>", "<col=ffb000>", "<col=ff7000>", "<col=ff3000>", "<col=148200>", "<col=c0ff00>", "<col=80ff00>", "<col=40ff00>", "<col=D9D9D9>", "<col=A67711>", "<col=A10081>", "<col=ffff00>", "<col=FF00>", "<col=FF>", "<col=ff0000>", "<col=FFFF>", "<col=ff00ff>", "<col=ffffff>", "<col=ff9040>", "<col=800000>", "<col=0>", "<col=ffb000>", "<col=ff7000>", "<col=ff3000>", "<col=c0ff00>", "<col=80ff00>", "<col=40ff00>"};
    private static final Pattern CR_PATTERN = Pattern.compile("@cr(\\d+)@");
    private static DecimalFormat formatter;

    public static String handleOldSyntax(String text) {
        if (text == null) {
            return null;
        }
        text = StringUtils.replaceEach(text, searchList, replacementList);
        Matcher m3 = CR_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            m3.appendReplacement(sb, "<img=" + m3.group(1) + ">");
        }
        m3.appendTail(sb);
        return sb.toString();
    }

    public static String removeMarkup(String s2) {
        boolean stopAdding = false;
        StringBuilder stringbuffer = new StringBuilder(s2.length());
        for (int charIndex = 0; charIndex < s2.length(); ++charIndex) {
            char c = s2.charAt(charIndex);
            if (c == '<') {
                stopAdding = true;
                continue;
            }
            if (c == '>') {
                stopAdding = false;
                continue;
            }
            if (stopAdding) continue;
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    public static String formatTimePlayed(Stopwatch stopwatch) {
        long seconds = stopwatch.elapsedTime(TimeUnit.SECONDS) % 60L;
        long minutes = stopwatch.elapsedTime(TimeUnit.MINUTES) % 60L;
        long hours = stopwatch.elapsedTime(TimeUnit.HOURS) % 24L;
        StringBuilder builder = new StringBuilder();
        if (hours < 10L) {
            builder.append("0");
        }
        builder.append(hours).append(":");
        if (minutes < 10L) {
            builder.append("0");
        }
        builder.append(minutes).append(":");
        if (seconds < 10L) {
            builder.append("0");
        }
        builder.append(seconds);
        return builder.toString();
    }

    public static String passwordAsterisks(String s2) {
        int length = s2.length();
        StringBuilder result2 = new StringBuilder(length);
        for (int j = 0; j < length; ++j) {
            result2.append("*");
        }
        return result2.toString();
    }

    public static String formatName(String name) {
        if (name.isEmpty()) {
            return name;
        }
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(Character.toUpperCase(name.charAt(0)));
        for (int index = 1; index < length; ++index) {
            char character = name.charAt(index);
            if (character == '_' || character == ' ') {
                sb.append(character);
                int nextIndex = index + 1;
                if (nextIndex >= length || (character = name.charAt(nextIndex)) < 'a' || character > 'z') continue;
                sb.append(Character.toUpperCase(character));
                ++index;
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public static String formatNumbersWithCommas(long number) {
        return formatter.format(number);
    }

    public static int stringToIntRadix(String string2, int radix, boolean canStartWithPlus) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Invalid radix:" + radix);
        }
        boolean negative = false;
        boolean resultFound = false;
        int oldResult = 0;
        int stringLength = string2.length();
        for (int charIndex = 0; charIndex < stringLength; ++charIndex) {
            int result2;
            int value = string2.charAt(charIndex);
            if (charIndex == 0) {
                if (value == 45) {
                    negative = true;
                    continue;
                }
                if (value == 43 && canStartWithPlus) continue;
            }
            if (value >= 48 && value <= 57) {
                value -= 48;
            } else if (value >= 65 && value <= 90) {
                value -= 55;
            } else if (value >= 97 && value <= 122) {
                value -= 87;
            } else {
                throw new NumberFormatException();
            }
            if (radix <= value) {
                throw new NumberFormatException();
            }
            if (negative) {
                value = -value;
            }
            if ((result2 = oldResult * radix + value) / radix != oldResult) {
                throw new NumberFormatException();
            }
            resultFound = true;
            oldResult = result2;
        }
        if (!resultFound) {
            throw new NumberFormatException();
        }
        return oldResult;
    }

    public static int stringToInt16(String string2) {
        return Strings.stringToIntRadix(string2, 16, true);
    }

    public static int stringToInt10(String string2) {
        return Strings.stringToIntRadix(string2, 10, true);
    }

    static {
        DecimalFormatSymbols separator = new DecimalFormatSymbols();
        separator.setGroupingSeparator(',');
        formatter = new DecimalFormat("#,###,###,###,###,###", separator);
    }
}

