/*
 * Decompiled with CFR 0.152.
 */
package com.client.utilities;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class TempWriter {
    private static final Logger logger = Logger.getLogger(TempWriter.class.getSimpleName());
    private final Path path = Paths.get("temp/", new String[0]);
    private final String file;
    private BufferedWriter writer;

    public TempWriter(String file) {
        this.file = file;
    }

    public void writeLine(String line) {
        try {
            if (this.writer == null) {
                if (!this.path.toFile().exists() && !this.path.toFile().mkdirs()) {
                    throw new IllegalStateException();
                }
                Path filePath = this.path.resolve(this.file + ".txt");
                if (filePath.toFile().exists() && !filePath.toFile().delete()) {
                    throw new IllegalStateException();
                }
                this.writer = new BufferedWriter(new FileWriter(filePath.toString()));
            }
            this.writer.write(line);
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            logger.info("Wrote temp file: " + this.file);
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

