/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index.archive;

import com.displee.cache.index.archive.file.File;
import com.displee.compress.CompressionType;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00172\b\b\u0002\u0010?\u001a\u00020'H\u0007J1\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00170@2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170@\"\u00020\u00172\b\b\u0002\u0010?\u001a\u00020'H\u0007\u00a2\u0006\u0002\u0010AJ\u000e\u0010=\u001a\u00020\u00172\u0006\u0010B\u001a\u000204J,\u0010=\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010B\u001a\u0002042\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010?\u001a\u00020'H\u0007J\"\u0010=\u001a\u00020\u00172\u0006\u0010C\u001a\u00020D2\u0006\u0010B\u001a\u0002042\b\b\u0002\u0010?\u001a\u00020'H\u0007J\u0006\u0010E\u001a\u00020FJ\u0011\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010I\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010I\u001a\u00020'2\u0006\u0010C\u001a\u00020DJ\u0006\u0010J\u001a\u00020'J\u0011\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00170@\u00a2\u0006\u0002\u0010LJ\u0010\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010B\u001a\u000204J\u0010\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010C\u001a\u00020DJ\u000e\u0010M\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DJ\u0006\u0010N\u001a\u00020\tJ\u0011\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170@\u00a2\u0006\u0002\u0010LJ\b\u0010O\u001a\u0004\u0018\u00010\u0017J\u0006\u0010P\u001a\u00020FJ\u0006\u0010Q\u001a\u00020'J\b\u0010R\u001a\u0004\u0018\u00010\u0017J\u0006\u0010S\u001a\u00020\u0003J\u0010\u0010-\u001a\u00020F2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010V\u001a\u0004\u0018\u00010\u00172\u0006\u0010C\u001a\u00020DJ\u0006\u0010W\u001a\u00020FJ\u0010\u0010X\u001a\u00020\u00032\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010Y\u001a\u00020DH\u0016J\u0006\u0010Z\u001a\u00020FJ\b\u0010[\u001a\u000204H\u0016J\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\b\u001a\u00020F2\b\u0010\b\u001a\u0004\u0018\u00010\tR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0004R\u001a\u0010\u001d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0004R\u001a\u0010 \u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0004R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001a\u00100\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0013\"\u0004\b2\u0010\u0004R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006\\"}, d2={"Lcom/displee/cache/index/archive/Archive;", "", "id", "", "(I)V", "archive", "(Lcom/displee/cache/index/archive/Archive;)V", "hashName", "xtea", "", "(II[I)V", "compressionType", "Lcom/displee/compress/CompressionType;", "getCompressionType", "()Lcom/displee/compress/CompressionType;", "setCompressionType", "(Lcom/displee/compress/CompressionType;)V", "crc", "getCrc", "()I", "setCrc", "files", "Ljava/util/SortedMap;", "Lcom/displee/cache/index/archive/file/File;", "getFiles", "()Ljava/util/SortedMap;", "flag4Value1", "getFlag4Value1", "setFlag4Value1", "flag4Value2", "getFlag4Value2", "setFlag4Value2", "flag8Value", "getFlag8Value", "setFlag8Value", "getHashName", "setHashName", "getId", "needUpdate", "", "new", "getNew", "()Z", "setNew", "(Z)V", "read", "getRead", "setRead", "revision", "getRevision", "setRevision", "whirlpool", "", "getWhirlpool", "()[B", "setWhirlpool", "([B)V", "getXtea$rs_cache_library", "()[I", "setXtea$rs_cache_library", "([I)V", "add", "file", "overwrite", "", "([Lcom/displee/cache/index/archive/file/File;Z)[Lcom/displee/cache/index/archive/file/File;", "data", "name", "", "clear", "", "compareTo", "other", "contains", "containsData", "copyFiles", "()[Lcom/displee/cache/index/archive/file/File;", "fileId", "fileIds", "first", "flag", "flagged", "last", "nextId", "buffer", "Lcom/displee/io/impl/InputBuffer;", "remove", "restore", "toHash", "toString", "unFlag", "write", "rs-cache-library"})
public class Archive
implements Comparable<Archive> {
    @Nullable
    private CompressionType compressionType;
    private int revision;
    private boolean needUpdate;
    @NotNull
    private final SortedMap<Integer, File> files;
    private int crc;
    @Nullable
    private byte[] whirlpool;
    private int flag8Value;
    private int flag4Value1;
    private int flag4Value2;
    private boolean read;
    private boolean new;
    private final int id;
    private int hashName;
    @Nullable
    private int[] xtea;

    @Nullable
    public final CompressionType getCompressionType() {
        return this.compressionType;
    }

    public final void setCompressionType(@Nullable CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public final int getRevision() {
        return this.revision;
    }

    public final void setRevision(int n) {
        this.revision = n;
    }

    @NotNull
    public final SortedMap<Integer, File> getFiles() {
        return this.files;
    }

    public final int getCrc() {
        return this.crc;
    }

    public final void setCrc(int n) {
        this.crc = n;
    }

    @Nullable
    public final byte[] getWhirlpool() {
        return this.whirlpool;
    }

    public final void setWhirlpool(@Nullable byte[] byArray) {
        this.whirlpool = byArray;
    }

    public final int getFlag8Value() {
        return this.flag8Value;
    }

    public final void setFlag8Value(int n) {
        this.flag8Value = n;
    }

    public final int getFlag4Value1() {
        return this.flag4Value1;
    }

    public final void setFlag4Value1(int n) {
        this.flag4Value1 = n;
    }

    public final int getFlag4Value2() {
        return this.flag4Value2;
    }

    public final void setFlag4Value2(int n) {
        this.flag4Value2 = n;
    }

    public final boolean getRead() {
        return this.read;
    }

    public final void setRead(boolean bl) {
        this.read = bl;
    }

    public final boolean getNew() {
        return this.new;
    }

    public final void setNew(boolean bl) {
        this.new = bl;
    }

    @Override
    public int compareTo(@NotNull Archive other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return Intrinsics.compare(this.id, other.id);
    }

    /*
     * WARNING - void declaration
     */
    public void read(@NotNull InputBuffer buffer) {
        int i;
        int n;
        int offset;
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.read = true;
        byte[] rawArray = buffer.raw();
        if (this.files.size() == 1) {
            File file = this.first();
            if (file != null) {
                file.setData(rawArray);
            }
            return;
        }
        int[] fileIds = this.fileIds();
        int fileDataSizesOffset = rawArray.length;
        int chunkSize = rawArray[--fileDataSizesOffset] & 0xFF;
        int[] fileDataSizes = new int[fileIds.length];
        buffer.setOffset(fileDataSizesOffset -= chunkSize * (fileIds.length * 4));
        int n2 = 0;
        int n3 = chunkSize;
        while (n2 < n3) {
            void i2;
            offset = 0;
            n = 0;
            int n4 = fileIds.length;
            while (n < n4) {
                void fileIndex;
                void v1 = fileIndex++;
                fileDataSizes[v1] = fileDataSizes[v1] + (offset += buffer.readInt());
            }
            ++i2;
        }
        byte[][] filesData = new byte[fileIds.length][];
        n3 = 0;
        offset = fileIds.length;
        while (n3 < offset) {
            void i3;
            filesData[i3] = new byte[fileDataSizes[i3]];
            fileDataSizes[i3] = 0;
            ++i3;
        }
        buffer.setOffset(fileDataSizesOffset);
        int offset2 = 0;
        offset = 0;
        n = chunkSize;
        while (offset < n) {
            int read2 = 0;
            int n5 = 0;
            int n6 = fileIds.length;
            while (n5 < n6) {
                void j;
                System.arraycopy(rawArray, offset2, filesData[j], fileDataSizes[j], read2 += buffer.readInt());
                offset2 += read2;
                void v2 = j++;
                fileDataSizes[v2] = fileDataSizes[v2] + read2;
            }
            ++i;
        }
        n = fileIds.length;
        for (i = 0; i < n; ++i) {
            File file = this.file(fileIds[i]);
            if (file == null) continue;
            file.setData(filesData[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] write() {
        byte[] emptyByteArray;
        OutputBuffer buffer;
        File[] files;
        block9: {
            Object object;
            block11: {
                block10: {
                    files = this.files();
                    int size = 0;
                    File[] $this$forEach$iv = files;
                    boolean $i$f$forEach = false;
                    File[] fileArray = $this$forEach$iv;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = fileArray[i];
                        boolean bl = false;
                        byte[] byArray = it.getData();
                        size += byArray != null ? byArray.length : 0;
                    }
                    buffer = new OutputBuffer(size + files.length * 4);
                    emptyByteArray = new byte[]{};
                    if (files.length != 1) break block9;
                    object = this.first();
                    if (object == null) break block10;
                    byte[] byArray = ((File)object).getData();
                    object = byArray;
                    if (byArray != null) break block11;
                }
                object = emptyByteArray;
            }
            return object;
        }
        File[] $this$forEach$iv = files;
        int $i$f$forEach = 0;
        File[] fileArray = $this$forEach$iv;
        int element$iv = fileArray.length;
        for (int it = 0; it < element$iv; ++it) {
            File element$iv2;
            File it2 = element$iv2 = fileArray[it];
            boolean bl = false;
            byte[] byArray = it2.getData();
            if (byArray == null) {
                byArray = emptyByteArray;
            }
            buffer.writeBytes(byArray);
        }
        int chunks = 1;
        $i$f$forEach = 0;
        int n = files.length;
        while ($i$f$forEach < n) {
            int n2;
            int fileDataSize;
            void i;
            File file = files[i];
            byte[] byArray = file.getData();
            int n3 = fileDataSize = byArray != null ? byArray.length : 0;
            if (i == false) {
                n2 = 0;
            } else {
                byte[] byArray2 = files[i - true].getData();
                n2 = byArray2 != null ? byArray2.length : 0;
            }
            int previousFileDataSize = n2;
            buffer.writeInt(fileDataSize - previousFileDataSize);
            ++i;
        }
        buffer.writeByte(chunks);
        return Buffer.array$default(buffer, 0, 0, 3, null);
    }

    public final boolean containsData() {
        for (File entry : this.files.values()) {
            if (entry.getData() == null) continue;
            return true;
        }
        return false;
    }

    @JvmOverloads
    @NotNull
    public final File[] add(@NotNull File[] files, boolean overwrite) {
        Intrinsics.checkParameterIsNotNull(files, "files");
        ArrayList<File> newFiles = new ArrayList<File>(files.length);
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        File[] fileArray = $this$forEach$iv;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = fileArray[i];
            boolean bl = false;
            newFiles.add(this.add(it, overwrite));
        }
        Collection $this$toTypedArray$iv = newFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray2 = thisCollection$iv.toArray(new File[0]);
        if (fileArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return fileArray2;
    }

    public static /* synthetic */ File[] add$default(Archive archive, File[] fileArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return archive.add(fileArray, bl);
    }

    @JvmOverloads
    @NotNull
    public final File[] add(File ... files) {
        return Archive.add$default(this, files, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull File file, boolean overwrite) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        byte[] fileData = file.getData();
        boolean bl = false;
        boolean bl2 = false;
        if (fileData == null) {
            boolean bl3 = false;
            String string2 = "File data is null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return this.add(file.getId(), fileData, file.getHashName(), overwrite);
    }

    public static /* synthetic */ File add$default(Archive archive, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return archive.add(file, bl);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull File file) {
        return Archive.add$default(this, file, false, 2, null);
    }

    @NotNull
    public final File add(@NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return Archive.add$default(this, this.nextId(), data2, 0, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull String name, @NotNull byte[] data2, boolean overwrite) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        int id = this.fileId(name);
        if (id == -1) {
            id = this.nextId();
        }
        return this.add(id, data2, this.toHash(name), overwrite);
    }

    public static /* synthetic */ File add$default(Archive archive, String string2, byte[] byArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return archive.add(string2, byArray, bl);
    }

    @JvmOverloads
    @NotNull
    public final File add(@NotNull String name, @NotNull byte[] data2) {
        return Archive.add$default(this, name, data2, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2, int hashName, boolean overwrite) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        File file = (File)this.files.get(id);
        if (file == null) {
            file = new File(id, data2, hashName == -1 ? 0 : hashName);
            ((Map)this.files).put(id, file);
            this.flag();
        } else if (overwrite) {
            boolean flag = false;
            if (!Arrays.equals(file.getData(), data2)) {
                file.setData(data2);
                flag = true;
            }
            if (hashName != -1 && file.getHashName() != hashName) {
                file.setHashName(hashName);
                flag = true;
            }
            if (flag) {
                this.flag();
            }
        }
        return file;
    }

    public static /* synthetic */ File add$default(Archive archive, int n, byte[] byArray, int n2, boolean bl, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return archive.add(n, byArray, n2, bl);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2, int hashName) {
        return Archive.add$default(this, id, data2, hashName, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final File add(int id, @NotNull byte[] data2) {
        return Archive.add$default(this, id, data2, 0, false, 12, null);
    }

    @Nullable
    public final File file(int id) {
        return (File)this.files.get(id);
    }

    @Nullable
    public final File file(@NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Map $this$filterValues$iv = this.files;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map2.entrySet()) {
            File it = (File)entry$iv.getValue();
            boolean bl2 = false;
            if (!Arrays.equals(it.getData(), data2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (File)CollectionsKt.firstOrNull(((Map)result$iv).values());
    }

    @Nullable
    public final File file(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Map $this$filterValues$iv = this.files;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map2.entrySet()) {
            File it = (File)entry$iv.getValue();
            boolean bl2 = false;
            if (!(it.getHashName() == this.toHash(name))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (File)CollectionsKt.firstOrNull(((Map)result$iv).values());
    }

    public final boolean contains(int id) {
        return this.files.containsKey(id);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.fileId(name) != -1;
    }

    @Nullable
    public final File remove(int id) {
        File file = (File)this.files.remove(id);
        if (file == null) {
            return null;
        }
        File file2 = file;
        this.flag();
        return file2;
    }

    @Nullable
    public final File remove(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.remove(this.fileId(name));
    }

    @Nullable
    public final File first() {
        if (this.files.isEmpty()) {
            return null;
        }
        Integer n = this.files.firstKey();
        Intrinsics.checkExpressionValueIsNotNull(n, "files.firstKey()");
        return this.file(((Number)n).intValue());
    }

    @Nullable
    public final File last() {
        if (this.files.isEmpty()) {
            return null;
        }
        return (File)this.files.get(this.files.lastKey());
    }

    public final int fileId(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        int hashName = this.toHash(name);
        Collection<File> collection = this.files.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "files.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.getHashName() != hashName) continue;
            return it.getId();
        }
        return -1;
    }

    public final int nextId() {
        File last2 = this.last();
        return last2 == null ? 0 : last2.getId() + 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File[] copyFiles() {
        File[] files = this.files();
        ArrayList<File> copy2 = new ArrayList<File>(files.length);
        int n = 0;
        int n2 = files.length;
        while (n < n2) {
            void i;
            copy2.add((int)i, new File(files[i]));
            ++i;
        }
        Collection $this$toTypedArray$iv = copy2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return fileArray;
    }

    public final void flag() {
        this.needUpdate = true;
    }

    public final boolean flagged() {
        return this.needUpdate;
    }

    public final void unFlag() {
        if (!this.flagged()) {
            return;
        }
        this.needUpdate = false;
    }

    public final void restore() {
        for (File file : this.files.values()) {
            file.setData(null);
        }
        this.read = false;
        this.new = false;
    }

    public final void clear() {
        this.files.clear();
    }

    @NotNull
    public final int[] fileIds() {
        Set<Integer> set = this.files.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "files.keys");
        return CollectionsKt.toIntArray((Collection<Integer>)set);
    }

    @NotNull
    public final File[] files() {
        Collection<File> collection = this.files.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "files.values");
        Collection<File> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<File> thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return fileArray;
    }

    public final void xtea(@Nullable int[] xtea) {
        this.xtea = xtea;
        if (this.read) {
            this.compressionType = CompressionType.GZIP;
            this.flag();
        }
    }

    @Nullable
    public final int[] xtea() {
        return this.xtea;
    }

    public int toHash(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return name.hashCode();
    }

    @NotNull
    public String toString() {
        return "Archive[id=" + this.id + ", hash_name=" + this.hashName + ", revision=" + this.revision + ", crc=" + this.crc + ", has_whirlpool=" + (this.whirlpool != null) + ", read=" + this.read + ", files_size=" + this.files.size() + ']';
    }

    public final int getId() {
        return this.id;
    }

    public final int getHashName() {
        return this.hashName;
    }

    public final void setHashName(int n) {
        this.hashName = n;
    }

    @Nullable
    public final int[] getXtea$rs_cache_library() {
        return this.xtea;
    }

    public final void setXtea$rs_cache_library(@Nullable int[] nArray) {
        this.xtea = nArray;
    }

    public Archive(int id, int hashName, @Nullable int[] xtea) {
        this.id = id;
        this.hashName = hashName;
        this.xtea = xtea;
        this.files = new TreeMap();
    }

    public /* synthetic */ Archive(int n, int n2, int[] nArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            nArray = null;
        }
        this(n, n2, nArray);
    }

    public Archive(int id) {
        this(id, 0, null, 4, null);
    }

    public Archive(@NotNull Archive archive) {
        int[] nArray;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull(archive, "archive");
        this(archive.id, archive.hashName, null, 4, null);
        for (File file : archive.files()) {
            ((Map)this.files).put(file.getId(), new File(file));
        }
        this.revision = archive.revision;
        this.crc = archive.crc;
        if (archive.whirlpool != null) {
            byArray = (byte[])archive.whirlpool.clone();
        } else {
            byte[] cfr_ignored_0 = archive.whirlpool;
            byArray = this.whirlpool = null;
        }
        if (archive.xtea != null) {
            nArray = (int[])archive.xtea.clone();
        } else {
            int[] cfr_ignored_1 = archive.xtea;
            nArray = null;
        }
        this.xtea = nArray;
    }
}

