/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public final class DeclaredMembers {
    private DeclaredMembers() {
    }

    public static Field[] getDeclaredFields(Class<?> type2) {
        return (Field[])Arrays.stream(type2.getDeclaredFields()).sorted(Comparator.comparing(Field::getName).thenComparing(Field::getType, Comparator.comparing(Class::getName))).toArray(Field[]::new);
    }

    public static Method[] getDeclaredMethods(Class<?> type2) {
        return (Method[])Arrays.stream(type2.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName).thenComparing(Method::getReturnType, Comparator.comparing(Class::getName)).thenComparing(method -> Arrays.asList(method.getParameterTypes()), Ordering.from(Comparator.comparing(Class::getName)).lexicographical())).toArray(Method[]::new);
    }
}

