/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class NonBlockingPool<T>
extends ObjectPool<T> {
    private final Queue<T> queue;
    private final PoolableObject<T> poolableObject;

    NonBlockingPool(PoolableObject<T> poolableObject) {
        this(poolableObject, new ConcurrentLinkedQueue());
    }

    NonBlockingPool(PoolableObject<T> poolableObject, Queue<T> queue) {
        this.poolableObject = poolableObject;
        this.queue = queue;
    }

    @Override
    public T take() {
        T take2 = this.queue.poll();
        if (take2 == null) {
            take2 = this.poolableObject.create();
        }
        this.poolableObject.onTake(take2);
        return take2;
    }

    @Override
    public T takeInterruptibly() throws InterruptedException {
        return this.take();
    }

    @Override
    public void put(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(object);
    }

    @Override
    public T newInstance() {
        return this.poolableObject.create();
    }
}

