/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.overlays;

import com.google.inject.Inject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.HdPlugin;
import net.runelite.client.plugins.hd.data.materials.Material;
import net.runelite.client.plugins.hd.data.materials.Underlay;
import net.runelite.client.plugins.hd.utils.HDUtils;
import net.runelite.client.plugins.hd.utils.ModelHash;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TileInfoOverlay
extends Overlay {
    private final Client client;
    private Point mousePos;
    private boolean ctrlPressed;
    @Inject
    private HdPlugin plugin;

    @Inject
    public TileInfoOverlay(Client client) {
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        int plane;
        this.ctrlPressed = this.client.isKeyPressed(82);
        this.mousePos = this.client.getMouseCanvasPosition();
        if (this.mousePos != null && this.mousePos.getX() == -1 && this.mousePos.getY() == -1) {
            return null;
        }
        g2.setFont(FontManager.getRunescapeFont());
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int n = plane = this.ctrlPressed ? 3 : this.client.getPlane();
        while (plane >= 0) {
            for (int isBridge = 1; isBridge >= 0; --isBridge) {
                for (int x = 0; x < 104; ++x) {
                    for (int y = 0; y < 104; ++y) {
                        boolean shouldDraw;
                        Tile tile = tiles[plane][x][y];
                        boolean bl = shouldDraw = tile != null && (isBridge == 0 || tile.getBridge() != null);
                        if (!shouldDraw || !this.drawTileInfo(g2, tile)) continue;
                        return null;
                    }
                }
            }
            --plane;
        }
        return null;
    }

    private boolean drawTileInfo(Graphics2D g2, Tile tile) {
        boolean infoDrawn = false;
        if (tile != null) {
            Polygon poly;
            Rectangle rect = null;
            Tile bridge = tile.getBridge();
            if (bridge != null && (poly = TileInfoOverlay.getCanvasTilePoly(this.client, bridge)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g2, bridge, poly, rect)) != null) {
                infoDrawn = true;
            }
            if ((poly = TileInfoOverlay.getCanvasTilePoly(this.client, tile)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g2, tile, poly, rect)) != null) {
                infoDrawn = true;
            }
        }
        return infoDrawn;
    }

    private Rectangle drawTileInfo(Graphics2D g2, Tile tile, Polygon poly, Rectangle dodgeRect) {
        SceneTilePaint paint = tile.getSceneTilePaint();
        SceneTileModel model = tile.getSceneTileModel();
        if (!this.ctrlPressed && (paint == null || paint.getNeColor() == 12345678 && tile.getBridge() == null) && model == null) {
            return null;
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        Point tileCenter = new Point((int)polyBounds.getCenterX(), (int)polyBounds.getCenterY());
        ArrayList<Object> lines = new ArrayList<Object>();
        if (tile.getBridge() != null) {
            lines.add("Bridge");
        }
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int plane = tile.getRenderLevel();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, tile.getLocalLocation());
        String worldPointInfo = "World point: " + worldPoint.getX() + ", " + worldPoint.getY() + ", " + worldPoint.getPlane();
        lines.add(worldPointInfo);
        Scene scene = this.client.getScene();
        short overlayId = scene.getOverlayIds()[plane][x][y];
        net.runelite.client.plugins.hd.data.materials.Overlay overlay = net.runelite.client.plugins.hd.data.materials.Overlay.getOverlay(scene, tile, this.plugin);
        lines.add(String.format("Overlay: %s (%d)", overlay.name(), overlayId));
        short underlayId = scene.getUnderlayIds()[plane][x][y];
        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
        lines.add(String.format("Underlay: %s (%d)", underlay.name(), underlayId));
        Color polyColor = Color.BLACK;
        if (paint != null) {
            polyColor = Color.CYAN;
            lines.add("Tile type: Paint");
            Material material = Material.getTexture(paint.getTexture());
            lines.add(String.format("Material: %s (%d)", material.name(), paint.getTexture()));
            lines.add("JagexHSL: ");
            lines.add("NW: " + (Serializable)(paint.getNwColor() == 12345678 ? "HIDDEN" : Integer.valueOf(paint.getNwColor())));
            lines.add("NE: " + (Serializable)(paint.getNeColor() == 12345678 ? "HIDDEN" : Integer.valueOf(paint.getNeColor())));
            lines.add("SE: " + (Serializable)(paint.getSeColor() == 12345678 ? "HIDDEN" : Integer.valueOf(paint.getSeColor())));
            lines.add("SW: " + (Serializable)(paint.getSwColor() == 12345678 ? "HIDDEN" : Integer.valueOf(paint.getSwColor())));
        } else if (model != null) {
            polyColor = Color.ORANGE;
            lines.add("Tile type: Model");
            lines.add(String.format("Face count: %d", model.getFaceX().length));
            HashSet<String> uniqueMaterials = new HashSet<String>();
            int numChars = 0;
            if (model.getTriangleTextureId() != null) {
                for (int texture : model.getTriangleTextureId()) {
                    String material = String.format("%s (%d)", Material.getTexture(texture).name(), texture);
                    boolean unique = uniqueMaterials.add(material);
                    if (!unique) continue;
                    numChars += material.length();
                }
            }
            ArrayList materials = new ArrayList(uniqueMaterials);
            Collections.sort(materials);
            if (materials.size() <= 1 || numChars < 26) {
                StringBuilder sb = new StringBuilder("Materials: { ");
                if (materials.size() == 0) {
                    sb.append("null");
                } else {
                    String prefix = "";
                    for (String m3 : materials) {
                        sb.append(prefix).append(m3);
                        prefix = ", ";
                    }
                }
                sb.append(" }");
                lines.add(sb.toString());
            } else {
                Iterator iter = materials.iterator();
                lines.add("Materials: { " + (String)iter.next() + ",");
                while (iter.hasNext()) {
                    lines.add("\t  " + (String)iter.next() + (iter.hasNext() ? "," : " }"));
                }
            }
            lines.add("JagexHSL: ");
            int[] CA = model.getTriangleColorA();
            int[] CB = model.getTriangleColorB();
            int[] CC = model.getTriangleColorC();
            for (int face = 0; face < model.getFaceX().length; ++face) {
                int a = CA[face];
                int b = CB[face];
                int c = CC[face];
                if (a == b && b == c) {
                    lines.add(face + ": " + (Serializable)(a == 12345678 ? "HIDDEN" : Integer.valueOf(a)));
                    continue;
                }
                lines.add(face + ": [ " + (Serializable)(a == 12345678 ? "HIDDEN" : Integer.valueOf(a)) + ", " + (Serializable)(b == 12345678 ? "HIDDEN" : Integer.valueOf(b)) + ", " + (Serializable)(c == 12345678 ? "HIDDEN" : Integer.valueOf(c)) + " ]");
            }
        }
        if (this.client.isKeyPressed(81)) {
            GameObject[] gameObjects;
            GroundObject groundObject = tile.getGroundObject();
            if (groundObject != null) {
                lines.add(String.format("Ground Object: ID=%d x=%d y=%d ori=%d", groundObject.getId(), ModelHash.getSceneX(groundObject.getHash()), ModelHash.getSceneY(groundObject.getHash()), HDUtils.extractConfigOrientation(groundObject.getConfig())));
            }
            if ((gameObjects = tile.getGameObjects()).length > 0) {
                int counter = 0;
                for (int i = 0; i < gameObjects.length; ++i) {
                    GameObject gameObject = gameObjects[i];
                    if (gameObject == null) continue;
                    ++counter;
                    lines.add(String.format("ID %d: x=%d y=%d ori=%d", gameObject.getId(), ModelHash.getSceneX(gameObject.getHash()), ModelHash.getSceneY(gameObject.getHash()), gameObject.getModelOrientation()));
                }
                if (counter > 0) {
                    lines.add(lines.size() - counter, "Game objects: ");
                }
            }
        }
        int padding = 4;
        int xPadding = padding * 2;
        FontMetrics fm = g2.getFontMetrics();
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.size() + padding * 3;
        int space = fm.charWidth(':');
        int indent = fm.stringWidth("{ ");
        int leftWidth = 0;
        int rightWidth = 0;
        Function<String, Pair> splitter = line -> {
            int i = line.indexOf(":");
            String left = line;
            String right = "";
            if (left.startsWith("\t")) {
                right = left;
                left = "";
            } else if (i != -1) {
                left = line.substring(0, i);
                right = line.substring(i + 1);
            }
            return Pair.of(left, right);
        };
        for (String string2 : lines) {
            Pair pair = splitter.apply(string2);
            if (((String)pair.getRight()).length() == 0) {
                int halfWidth = fm.stringWidth((String)pair.getLeft()) / 2;
                leftWidth = Math.max(leftWidth, halfWidth);
                rightWidth = Math.max(rightWidth, halfWidth);
                continue;
            }
            leftWidth = Math.max(leftWidth, fm.stringWidth((String)pair.getLeft()));
            rightWidth = Math.max(rightWidth, fm.stringWidth((String)pair.getRight()));
        }
        int totalWidth = leftWidth + rightWidth + space + xPadding * 2;
        Rectangle rectangle = new Rectangle(tileCenter.getX() - totalWidth / 2, tileCenter.getY() - totalHeight - padding, totalWidth, totalHeight);
        if (dodgeRect != null && dodgeRect.intersects(rectangle)) {
            rectangle.y = dodgeRect.y - rectangle.height - padding;
        }
        if (tile.getBridge() != null) {
            polyColor = Color.MAGENTA;
        }
        g2.setColor(polyColor);
        g2.drawPolygon(poly);
        g2.setColor(new Color(0, 0, 0, 150));
        g2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int offsetY = 0;
        for (String string3 : lines) {
            Pair pair = splitter.apply(string3);
            Point p = ((String)pair.getRight()).length() == 0 ? new Point(rectangle.x + rectangle.width / 2 - fm.stringWidth((String)pair.getLeft()) / 2, rectangle.y + padding + offsetY) : new Point(rectangle.x + xPadding + leftWidth - fm.stringWidth((String)pair.getLeft()) + (((String)pair.getRight()).startsWith("\t") ? indent : 0), rectangle.y + padding + (offsetY += lineHeight));
            OverlayUtil.renderTextLocation(g2, p, string3, Color.WHITE);
        }
        return rectangle;
    }

    public static Polygon getCanvasTilePoly(@Nonnull Client client, Tile tile) {
        LocalPoint lp = tile.getLocalLocation();
        int plane = tile.getRenderLevel();
        if (!lp.isInScene()) {
            return null;
        }
        int swX = lp.getX() - 64;
        int swY = lp.getY() - 64;
        int neX = lp.getX() + 64;
        int neY = lp.getY() + 64;
        int swHeight = TileInfoOverlay.getHeight(client, swX, swY, plane);
        int nwHeight = TileInfoOverlay.getHeight(client, neX, swY, plane);
        int neHeight = TileInfoOverlay.getHeight(client, neX, neY, plane);
        int seHeight = TileInfoOverlay.getHeight(client, swX, neY, plane);
        Point p1 = Perspective.localToCanvas(client, swX, swY, swHeight);
        Point p2 = Perspective.localToCanvas(client, neX, swY, nwHeight);
        Point p3 = Perspective.localToCanvas(client, neX, neY, neHeight);
        Point p4 = Perspective.localToCanvas(client, swX, neY, seHeight);
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint(p1.getX(), p1.getY());
        poly.addPoint(p2.getX(), p2.getY());
        poly.addPoint(p3.getX(), p3.getY());
        poly.addPoint(p4.getX(), p4.getY());
        return poly;
    }

    private static int getHeight(@Nonnull Client client, int localX, int localY, int plane) {
        int sceneX = localX >> 7;
        int sceneY = localY >> 7;
        if (sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104) {
            int[][][] tileHeights = client.getTileHeights();
            int x = localX & 0x7F;
            int y = localY & 0x7F;
            int var8 = x * tileHeights[plane][sceneX + 1][sceneY] + (128 - x) * tileHeights[plane][sceneX][sceneY] >> 7;
            int var9 = tileHeights[plane][sceneX][sceneY + 1] * (128 - x) + x * tileHeights[plane][sceneX + 1][sceneY + 1] >> 7;
            return (128 - y) * var8 + y * var9 >> 7;
        }
        return 0;
    }
}

