/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.scene.lights;

import lombok.NonNull;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Projectile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.hd.scene.lights.Alignment;
import net.runelite.client.plugins.hd.scene.lights.Light;
import net.runelite.client.plugins.hd.scene.lights.LightType;
import net.runelite.client.plugins.hd.utils.HDUtils;

public class SceneLight
extends Light {
    public final int randomOffset = HDUtils.rand.nextInt();
    public int currentSize;
    public float currentStrength;
    public float[] currentColor;
    public float currentAnimation = 0.5f;
    public int currentFadeIn = 0;
    public boolean visible = true;
    public WorldPoint worldPoint;
    public int x;
    public int y;
    public int z;
    public int distance = 0;
    public boolean belowFloor = false;
    public boolean aboveFloor = false;
    public Projectile projectile = null;
    public NPC npc = null;
    public TileObject object = null;
    public GraphicsObject graphicsObject = null;

    public SceneLight(Light l, WorldPoint worldPoint) {
        this(l.description, worldPoint.getX(), worldPoint.getY(), l.plane, l.height, l.alignment, l.radius, l.strength, l.color, l.type, l.duration, l.range, l.fadeInDuration);
        this.worldPoint = worldPoint;
    }

    public SceneLight(int worldX, int worldY, int plane, int height, @NonNull Alignment alignment, int radius, float strength, float[] color, LightType type2, float duration, float range, int fadeInDuration) {
        this(null, worldX, worldY, plane, height, alignment, radius, strength, color, type2, duration, range, fadeInDuration);
        if (alignment == null) {
            throw new NullPointerException("alignment is marked non-null but is null");
        }
    }

    public SceneLight(String description2, int worldX, int worldY, int plane, int height, @NonNull Alignment alignment, int radius, float strength, float[] color, LightType type2, float duration, float range, int fadeInDuration) {
        super(description2, worldX, worldY, plane, height, alignment, radius, strength, color, type2, duration, range, fadeInDuration, null, null, null, null);
        if (alignment == null) {
            throw new NullPointerException("alignment is marked non-null but is null");
        }
        this.currentSize = radius;
        this.currentStrength = strength;
        this.currentColor = color;
        if (type2 == LightType.PULSE) {
            this.currentAnimation = (float)Math.random();
        }
    }
}

