/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.util.HashSet;
import java.util.Random;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Scene;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HDUtils {
    private static final Logger log = LoggerFactory.getLogger(HDUtils.class);
    public static final Random rand = new Random();
    private static final float[] lightDirTile = new float[]{0.70710677f, 0.70710677f, 0.0f};
    public static final float[] lightDirModel = new float[]{0.57735026f, 0.57735026f, 0.57735026f};
    public static final float EPSILON = 1.1920929E-7f;

    public static float[] vectorAdd(float[] vec1, float[] vec2) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static float[] vectorAdd(float[] vec1, int[] vec2) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + (float)vec2[i];
        }
        return out;
    }

    static int[] vectorAdd(int[] vec1, int[] vec2) {
        int[] out = new int[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static double[] vectorAdd(double[] vec1, double[] vec2) {
        double[] out = new double[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static Double[] vectorAdd(Double[] vec1, Double[] vec2) {
        Double[] out = new Double[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = vec1[i] + vec2[i];
        }
        return out;
    }

    static float[] vectorDivide(float[] vec1, float divide) {
        float[] out = new float[vec1.length];
        for (int i = 0; i < vec1.length; ++i) {
            out[i] = divide == 0.0f ? 0.0f : vec1[i] / divide;
        }
        return out;
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static float[] lerpVectors(float[] vecA, float[] vecB, float t) {
        float[] out = new float[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    static int[] lerpVectors(int[] vecA, int[] vecB, float t) {
        int[] out = new int[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (int)HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    public static int clamp(int value, int min2, int max) {
        return Math.min(max, Math.max(min2, value));
    }

    public static float clamp(float value, float min2, float max) {
        return Math.min(max, Math.max(min2, value));
    }

    public static int vertexHash(int[] vPos) {
        StringBuilder s2 = new StringBuilder();
        for (int part : vPos) {
            s2.append(part).append(",");
        }
        return s2.toString().hashCode();
    }

    public static float[] calculateSurfaceNormals(int[] vertexX, int[] vertexY, int[] vertexZ) {
        float[] a = new float[]{vertexX[0] - vertexX[1], vertexY[0] - vertexY[1], vertexZ[0] - vertexZ[1]};
        float[] b = new float[]{vertexX[0] - vertexX[2], vertexY[0] - vertexY[2], vertexZ[0] - vertexZ[2]};
        float[] n = new float[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        return n;
    }

    public static int[] colorIntToHSL(int colorInt) {
        int[] outHSL = new int[]{colorInt >> 10 & 0x3F, colorInt >> 7 & 7, colorInt & 0x7F};
        return outHSL;
    }

    public static int colorHSLToInt(int[] colorHSL) {
        return (colorHSL[0] << 3 | colorHSL[1]) << 7 | colorHSL[2];
    }

    public static int[] colorIntToRGB(int colorInt) {
        int[] outHSL = new int[]{colorInt >> 10 & 0x3F, colorInt >> 7 & 7, colorInt & 0x7F};
        return HDUtils.colorHSLToRGB(outHSL[0], outHSL[1], outHSL[2]);
    }

    public static int colorRGBToInt(float[] colorRGB) {
        int[] colorRGBInt = new int[3];
        for (int i = 0; i < colorRGB.length; ++i) {
            colorRGBInt[i] = (int)(colorRGB[i] * 255.0f);
        }
        return (colorRGBInt[0] << 8 | colorRGBInt[1]) << 8 | colorRGBInt[2] | 0x8000000;
    }

    static int[] colorHSLToRGB(float h2, float s2, float l) {
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s2) : (l /= 128.0f) + (s2 /= 8.0f) - s2 * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, HDUtils.HueToRGB(p, q, (h2 /= 64.0f) + 0.33333334f));
        float g2 = Math.max(0.0f, HDUtils.HueToRGB(p, q, h2));
        float b = Math.max(0.0f, HDUtils.HueToRGB(p, q, h2 - 0.33333334f));
        r = Math.min(r, 1.0f);
        g2 = Math.min(g2, 1.0f);
        b = Math.min(b, 1.0f);
        return new int[]{(int)(r * 255.0f), (int)(g2 * 255.0f), (int)(b * 255.0f)};
    }

    static float HueToRGB(float p, float q, float h2) {
        if (h2 < 0.0f) {
            h2 += 1.0f;
        }
        if (h2 > 1.0f) {
            h2 -= 1.0f;
        }
        if (6.0f * h2 < 1.0f) {
            return p + (q - p) * 6.0f * h2;
        }
        if (2.0f * h2 < 1.0f) {
            return q;
        }
        if (3.0f * h2 < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h2);
        }
        return p;
    }

    public static float linearToSrgb(float c) {
        return (double)c <= 0.0031308 ? c * 12.92f : (float)(1.055 * Math.pow(c, 0.4166666666666667) - 0.055);
    }

    public static float srgbToLinear(float c) {
        return c <= 0.04045f ? c / 12.92f : (float)Math.pow(((double)c + 0.055) / 1.055, 2.4);
    }

    public static float[] linearToSrgb(float[] c) {
        float[] result2 = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result2[i] = HDUtils.linearToSrgb(c[i]);
        }
        return result2;
    }

    public static float[] srgbToLinear(float[] c) {
        float[] result2 = new float[c.length];
        for (int i = 0; i < c.length; ++i) {
            result2[i] = HDUtils.srgbToLinear(c[i]);
        }
        return result2;
    }

    public static float dotLightDirectionModel(float x, float y, float z) {
        float length = x * x + y * y + z * z;
        if (length < 1.1920929E-7f) {
            return 0.0f;
        }
        return (x * lightDirModel[0] + y * lightDirModel[1] + z * lightDirModel[2]) / (float)Math.sqrt(length);
    }

    public static float dotLightDirectionTile(float x, float y, float z) {
        float length = x * x + y * y + z * z;
        if (length < 1.1920929E-7f) {
            return 0.0f;
        }
        return (x * lightDirTile[0] + y * lightDirTile[1]) / (float)Math.sqrt(length);
    }

    public static float[] rgb(int r, int g2, int b) {
        return new float[]{HDUtils.srgbToLinear((float)r / 255.0f), HDUtils.srgbToLinear((float)g2 / 255.0f), HDUtils.srgbToLinear((float)b / 255.0f)};
    }

    public static long ceilPow2(long x) {
        return (long)Math.pow(2.0, Math.ceil(Math.log(x) / Math.log(2.0)));
    }

    public static int convertWallObjectOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                return 512;
            }
            case 2: {
                return 1024;
            }
            case 4: {
                return 1536;
            }
            case 8: {
                return 0;
            }
            case 16: {
                return 768;
            }
            case 32: {
                return 1280;
            }
            case 64: {
                return 1792;
            }
            case 128: {
                return 256;
            }
        }
        return 0;
    }

    public static int extractConfigOrientation(int config) {
        switch (config >> 6 & 3) {
            case 0: {
                return 1024;
            }
            case 1: {
                return 1536;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 512;
            }
        }
        return 0;
    }

    public static HashSet<Integer> getSceneRegionIds(Scene scene) {
        HashSet<Integer> regionIds = new HashSet<Integer>();
        if (scene.isInstance()) {
            int[][][] chunks;
            int[][][] nArray = chunks = scene.getInstanceTemplateChunks();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[][] plane;
                int[][] nArray2 = plane = nArray[i];
                int n2 = nArray2.length;
                for (int j = 0; j < n2; ++j) {
                    int[] column;
                    for (int chunk : column = nArray2[j]) {
                        if (chunk == -1) continue;
                        int x = chunk >> 14 & 0x3FF;
                        int y = chunk >> 3 & 0x7FF;
                        regionIds.add(x >> 3 << 8 | y >> 3);
                    }
                }
            }
        } else {
            int baseX = scene.getBaseX();
            int baseY = scene.getBaseY();
            for (int x = 0; x < 104; x += 64) {
                for (int y = 0; y < 104; y += 64) {
                    regionIds.add(baseX + x >> 6 << 8 | baseY + y >> 6);
                }
            }
        }
        return regionIds;
    }

    public static WorldPoint getSceneBase(Scene scene, int plane) {
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (scene.isInstance()) {
            int chunkX = 6;
            int chunkY = 6;
            int chunk = scene.getInstanceTemplateChunks()[plane][chunkX][chunkY];
            if (chunk == -1) {
                int[][] chunks = scene.getInstanceTemplateChunks()[plane];
                block0: for (chunkX = 0; chunkX < chunks.length; ++chunkX) {
                    for (chunkY = 0; chunkY < chunks[chunkX].length; ++chunkY) {
                        chunk = chunks[chunkX][chunkY];
                        if (chunk != -1) break block0;
                    }
                }
            }
            baseX = chunk >> 14 & 0x3FF;
            baseY = chunk >> 3 & 0x7FF;
            baseX -= chunkX;
            baseY -= chunkY;
            baseX <<= 3;
            baseY <<= 3;
        }
        return new WorldPoint(baseX, baseY, plane);
    }

    public static WorldPoint cameraSpaceToWorldPoint(Client client, int x, int z) {
        return WorldPoint.fromLocalInstance(client, new LocalPoint(x + client.getCameraX2(), z + client.getCameraZ2()));
    }
}

