/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.woodcutting;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

enum Tree {
    REGULAR_TREE(null, 1276, 1277, 1278, 1279, 1280),
    OAK_TREE(Duration.ofMillis(8500L), 4540, 10820),
    WILLOW_TREE(Duration.ofMillis(8500L), 10819, 10829, 10831, 10833),
    MAPLE_TREE(Duration.ofSeconds(35L), new int[]{10832, 36681}){

        @Override
        Duration getRespawnTime(int region) {
            return region == 10044 ? Duration.ofMillis(8500L) : this.respawnTime;
        }
    }
    ,
    TEAK_TREE(Duration.ofMillis(8500L), 9036, 36686),
    MAHOGANY_TREE(Duration.ofMillis(8500L), 9034, 36688),
    YEW_TREE(Duration.ofMinutes(1L), 10822, 10823, 36683),
    MAGIC_TREE(Duration.ofMinutes(2L), 10834, 10835),
    REDWOOD(Duration.ofMinutes(2L), 29668, 29670);

    @Nullable
    private final Duration respawnTime;
    private final int[] treeIds;
    private static final int MISCELLANIA_REGION = 10044;
    private static final Map<Integer, Tree> TREES;

    private Tree(Duration respawnTime, int ... treeIds) {
        this.respawnTime = respawnTime;
        this.treeIds = treeIds;
    }

    Duration getRespawnTime(int region) {
        return this.respawnTime;
    }

    static Tree findTree(int objectId) {
        return TREES.get(objectId);
    }

    @Nullable
    public Duration getRespawnTime() {
        return this.respawnTime;
    }

    public int[] getTreeIds() {
        return this.treeIds;
    }

    static {
        ImmutableMap.Builder<Integer, Tree> builder = new ImmutableMap.Builder<Integer, Tree>();
        for (Tree tree : Tree.values()) {
            for (int treeId : tree.treeIds) {
                builder.put(treeId, tree);
            }
        }
        TREES = builder.build();
    }
}

