/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import one.util.streamex.Internals;

final class WithFirstSpliterator<T, R>
extends Internals.CloneableSpliterator<R, WithFirstSpliterator<T, R>>
implements Consumer<T> {
    private static final int STATE_NONE = 0;
    private static final int STATE_FIRST_READ = 1;
    private static final int STATE_INIT = 2;
    private static final int STATE_EMPTY = 3;
    private ReentrantLock lock;
    private Spliterator<T> source;
    private WithFirstSpliterator<T, R> prefix;
    private volatile T first;
    private volatile int state = 0;
    private final BiFunction<? super T, ? super T, ? extends R> mapper;
    private Consumer<? super R> action;

    WithFirstSpliterator(Spliterator<T> source2, BiFunction<? super T, ? super T, ? extends R> mapper) {
        this.source = source2;
        this.mapper = mapper;
    }

    private void acquire() {
        if (this.lock != null && this.state == 0) {
            this.lock.lock();
        }
    }

    private void release() {
        if (this.lock != null && this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.state == 0) {
            this.acquire();
            try {
                this.doInit();
            }
            finally {
                this.release();
            }
        }
        if (this.state == 1) {
            this.state = 2;
            action.accept(this.mapper.apply(this.first, this.first));
            return true;
        }
        if (this.state != 2) {
            return false;
        }
        this.action = action;
        boolean hasNext = this.source.tryAdvance(this);
        this.action = null;
        return hasNext;
    }

    private void doInit() {
        int prefixState = this.state;
        if (prefixState != 0) {
            return;
        }
        if (this.prefix != null) {
            super.doInit();
            prefixState = this.prefix.state;
        }
        if (prefixState == 1 || prefixState == 2) {
            this.first = this.prefix.first;
            this.state = 2;
            return;
        }
        this.state = this.source.tryAdvance((? super T x) -> {
            this.first = x;
        }) ? 1 : 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        this.acquire();
        int myState = this.state;
        this.action = action;
        if (myState == 1 || myState == 2) {
            this.release();
            if (myState == 1) {
                this.state = 2;
                this.accept(this.first);
            }
            this.source.forEachRemaining(this);
            this.action = null;
            return;
        }
        try {
            Consumer<Object> init = x -> {
                if (this.state == 0) {
                    if (this.prefix != null) {
                        super.doInit();
                    }
                    this.first = this.prefix == null || this.prefix.state == 3 ? x : this.prefix.first;
                    this.state = 2;
                }
                this.release();
            };
            this.source.forEachRemaining(init.andThen(this));
            this.action = null;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<R> trySplit() {
        if (this.state != 0) {
            return null;
        }
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        this.acquire();
        try {
            if (this.state != 0) {
                Spliterator<R> spliterator = null;
                return spliterator;
            }
            Spliterator<T> prefix = this.source.trySplit();
            if (prefix == null) {
                Spliterator<R> spliterator = null;
                return spliterator;
            }
            WithFirstSpliterator result2 = (WithFirstSpliterator)this.doClone();
            result2.source = prefix;
            WithFirstSpliterator withFirstSpliterator = this.prefix = result2;
            return withFirstSpliterator;
        }
        finally {
            this.release();
        }
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return 0x100 | this.source.characteristics() & (0x1411 | (this.lock == null ? 64 : 0));
    }

    @Override
    public void accept(T x) {
        this.action.accept(this.mapper.apply(this.first, x));
    }
}

