/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSeparatorUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Container parent = c.getParent();
        if (!(parent instanceof JPopupMenu)) {
            SeparatorPainterUtils.paintSeparator(c, g2, c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        int xOffset = MenuUtilities.getTextOffset(c, parent);
        SubstanceMenuBackgroundDelegate.paintBackground(graphics, c, xOffset);
        Dimension s2 = c.getSize();
        int startX = 0;
        int width = s2.width;
        if (parent.getComponentOrientation().isLeftToRight()) {
            startX = xOffset - 2;
            width = s2.width - startX;
        } else {
            startX = 0;
            width = xOffset - 4;
        }
        graphics.translate(startX, 0);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(parent));
        SeparatorPainterUtils.paintSeparator(c, graphics, width, s2.height, ((JSeparator)c).getOrientation(), true, 2);
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(prefSize, 0);
        }
        return new Dimension(0, prefSize);
    }
}

