/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reflections8.ReflectionsException;
import org.reflections8.util.Utils;

public class FilterBuilder
implements Predicate<String> {
    private final List<Predicate<String>> chain = new ArrayList<Predicate<String>>();

    public FilterBuilder() {
    }

    private FilterBuilder(Iterable<Predicate<String>> filters) {
        filters.forEach(el -> this.chain.add((Predicate<String>)el));
    }

    public FilterBuilder include(String regex) {
        return this.add(new Include(regex));
    }

    public FilterBuilder exclude(String regex) {
        this.add(new Exclude(regex));
        return this;
    }

    public FilterBuilder add(Predicate<String> filter2) {
        this.chain.add(filter2);
        return this;
    }

    public FilterBuilder includePackage(Class<?> aClass) {
        return this.add(new Include(FilterBuilder.packageNameRegex(aClass)));
    }

    public FilterBuilder excludePackage(Class<?> aClass) {
        return this.add(new Exclude(FilterBuilder.packageNameRegex(aClass)));
    }

    public FilterBuilder includePackage(String ... prefixes) {
        for (String prefix : prefixes) {
            this.add(new Include(FilterBuilder.prefix(prefix)));
        }
        return this;
    }

    public FilterBuilder excludePackage(String prefix) {
        return this.add(new Exclude(FilterBuilder.prefix(prefix)));
    }

    private static String packageNameRegex(Class<?> aClass) {
        return FilterBuilder.prefix(aClass.getPackage().getName() + ".");
    }

    public static String prefix(String qualifiedName2) {
        return qualifiedName2.replace(".", "\\.") + ".*";
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ");
        this.chain.forEach(s2 -> j.add(s2.toString()));
        return j.toString();
    }

    @Override
    public boolean test(String regex) {
        boolean accept;
        boolean bl = accept = this.chain == null || this.chain.isEmpty() || this.chain.get(0) instanceof Exclude;
        if (this.chain != null) {
            for (Predicate<String> filter2 : this.chain) {
                if (accept && filter2 instanceof Include || !accept && filter2 instanceof Exclude || (accept = filter2.test(regex)) || !(filter2 instanceof Exclude)) continue;
                break;
            }
        }
        return accept;
    }

    public static FilterBuilder parse(String includeExcludeString) {
        ArrayList<Predicate<String>> filters = new ArrayList<Predicate<String>>();
        if (!Utils.isEmpty(includeExcludeString)) {
            for (String string2 : includeExcludeString.split(",")) {
                Matcher filter2;
                String trimmed = string2.trim();
                char prefix = trimmed.charAt(0);
                String pattern = trimmed.substring(1);
                switch (prefix) {
                    case '+': {
                        filter2 = new Include(pattern);
                        break;
                    }
                    case '-': {
                        filter2 = new Exclude(pattern);
                        break;
                    }
                    default: {
                        throw new ReflectionsException("includeExclude should start with either + or -");
                    }
                }
                filters.add(filter2);
            }
            return new FilterBuilder(filters);
        }
        return new FilterBuilder();
    }

    public static FilterBuilder parsePackages(String includeExcludeString) {
        ArrayList<Predicate<String>> filters = new ArrayList<Predicate<String>>();
        if (!Utils.isEmpty(includeExcludeString)) {
            for (String string2 : includeExcludeString.split(",")) {
                Matcher filter2;
                String trimmed = string2.trim();
                char prefix = trimmed.charAt(0);
                String pattern = trimmed.substring(1);
                if (!pattern.endsWith(".")) {
                    pattern = pattern + ".";
                }
                pattern = FilterBuilder.prefix(pattern);
                switch (prefix) {
                    case '+': {
                        filter2 = new Include(pattern);
                        break;
                    }
                    case '-': {
                        filter2 = new Exclude(pattern);
                        break;
                    }
                    default: {
                        throw new ReflectionsException("includeExclude should start with either + or -");
                    }
                }
                filters.add(filter2);
            }
            return new FilterBuilder(filters);
        }
        return new FilterBuilder();
    }

    public static class Exclude
    extends Matcher {
        public Exclude(String patternString) {
            super(patternString);
        }

        @Override
        public boolean test(String regex) {
            return !this.pattern.matcher(regex).matches();
        }

        @Override
        public String toString() {
            return "-" + super.toString();
        }
    }

    public static class Include
    extends Matcher {
        public Include(String patternString) {
            super(patternString);
        }

        @Override
        public boolean test(String regex) {
            return this.pattern.matcher(regex).matches();
        }

        @Override
        public String toString() {
            return "+" + super.toString();
        }
    }

    public static abstract class Matcher
    implements Predicate<String> {
        final Pattern pattern;

        public Matcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public abstract boolean test(String var1);

        public String toString() {
            return this.pattern.pattern();
        }
    }
}

